package com.biz.crm.mdm.business.customer.local.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerTagDto;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerTagVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 经销商标签管理接口定义
 * @Author: zengxingwang
 * @Date: 2021/12/21 19:38
 */
public interface CustomerTagVoMapper {

  /**
   * 多条件分页查询
   * @param page
   * @param customerTagDto
   * @return
   */
  Page<CustomerTagVo> findByConditions(Page<CustomerTagVo> page, @Param("customerTagDto") CustomerTagDto customerTagDto);

  /**
   * 通过客户编码集合查询客户标签列表
   *
   * @param customerCodes 客户编码集合
   * @param tenantCode 租户编码
   * @return 客户标签列表
   */
  List<CustomerTagVo> findByCustomerCodes(@Param("customerCodes") List<String> customerCodes, @Param("tenantCode") String tenantCode);

}
