package com.biz.crm.mdm.business.customer.local.service.internal;

import com.biz.crm.mdm.business.customer.local.entity.CustomerDockingSupplyEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerDockingSupplyRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerDockingSupplyService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerDockingSupplyDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 客户对接人供货信息表服务实现类
 *
 * @author ning.zhang
 * @date 2021-10-26 16:25:42
 */
@Service("customerDockingSupplyService")
public class CustomerDockingSupplyServiceImpl implements CustomerDockingSupplyService {

  @Autowired(required = false)
  private CustomerDockingSupplyRepository customerDockingSupplyRepository;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void deleteByDockingIds(List<String> dockingIds) {
    Validate.isTrue(CollectionUtils.isNotEmpty(dockingIds), "对接人ID不能为空");
    this.customerDockingSupplyRepository.deleteByDockingIds(dockingIds);
  }

  @Override
  @Transactional
  public void bindDockingId(List<CustomerDockingSupplyDto> dtoList, String dockingId) {
    Validate.notBlank(dockingId, "对接人ID不能为空");
    if (CollectionUtils.isEmpty(dtoList)) {
      return;
    }
    String tenantCode = TenantUtils.getTenantCode();
    List<CustomerDockingSupplyEntity> entities = dtoList.stream()
        .filter(dto -> Objects.nonNull(dto) && StringUtils.isNotBlank(dto.getCode()))
        .map(dto -> {
          CustomerDockingSupplyEntity entity = this.nebulaToolkitService
              .copyObjectByWhiteList(dto, CustomerDockingSupplyEntity.class, HashSet.class, ArrayList.class);
          entity.setDockingId(dockingId);
          entity.setTenantCode(tenantCode);
          return entity;
        }).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(entities)) {
      return;
    }
    this.customerDockingSupplyRepository.saveBatch(entities);
  }
}
