package com.biz.crm.mdm.business.customer.local.service.notifier;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.enums.FreezeStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerEventDto;
import com.biz.crm.mdm.business.customer.sdk.event.CustomerEventListener;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年05月23日 16:51:00
 */
@Component
public class CustomerLogEventListenerImpl implements CustomerEventListener {

  @Autowired(required = false)
  private CrmBusinessLogVoService crmBusinessLogVoService;

  /**
   * 创建
   *
   * @param eventDto
   */
  @Override
  public void onCreate(CustomerEventDto eventDto) {
    // 新对象
    CustomerVo newest = eventDto.getNewest();
    // 旧对象
    CustomerVo original = eventDto.getOriginal();
    String onlyKey = newest.getId();
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
    crmBusinessLogDto.setOnlyKey(onlyKey);
    crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setOldObject(original);
    crmBusinessLogDto.setNewObject(newest);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }

  @Override
  public void onCreateAndSubmit(CustomerEventDto dto) {
    CustomerVo original = dto.getOriginal();
    if (Objects.isNull(original)) {
      this.onCreate(dto);
    } else {
      this.onUpdate(dto);
    }
  }

  /**
   * 删除
   *
   * @param eventDto
   */
  @Override
  public void onDelete(CustomerEventDto eventDto) {
    // 新对象
    CustomerVo newest = eventDto.getNewest();
    // 旧对象
    CustomerVo original = eventDto.getOriginal();
    String onlyKey = original.getId();
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
    crmBusinessLogDto.setOnlyKey(onlyKey);
    crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setOldObject(original);
    crmBusinessLogDto.setNewObject(newest);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }

  /**
   * 更新
   *
   * @param eventDto
   */
  @Override
  public void onUpdate(CustomerEventDto eventDto) {
    // 新对象
    CustomerVo newest = eventDto.getNewest();
    // 旧对象
    CustomerVo original = eventDto.getOriginal();
    String onlyKey = newest.getId();
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
    crmBusinessLogDto.setOnlyKey(onlyKey);
    crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setOldObject(original);
    crmBusinessLogDto.setNewObject(newest);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }

  @Override
  public void onDisable(CustomerEventDto dto) {
    //新对象
    CustomerVo original = dto.getOriginal();
    String onlyKey = original.getId();
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
    crmBusinessLogDto.setOnlyKey(onlyKey);
    crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    //只需要传启禁用字段
    JSONObject oldObject =new JSONObject();
    JSONObject newObject =new JSONObject();
    oldObject.put("enableStatus",original.getEnableStatus());
    newObject.put("enableStatus", EnableStatusEnum.DISABLE.getCode());
    crmBusinessLogDto.setOldObject(oldObject);
    crmBusinessLogDto.setNewObject(newObject);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }

  @Override
  public void onEnable(CustomerEventDto dto) {
    //新对象
    CustomerVo original = dto.getOriginal();
    String onlyKey = original.getId();
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
    crmBusinessLogDto.setOnlyKey(onlyKey);
    crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    //只需要传启禁用字段
    JSONObject oldObject =new JSONObject();
    JSONObject newObject =new JSONObject();
    oldObject.put("enableStatus",original.getEnableStatus());
    newObject.put("enableStatus", EnableStatusEnum.ENABLE.getCode());
    crmBusinessLogDto.setOldObject(oldObject);
    crmBusinessLogDto.setNewObject(newObject);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }

  @Override
  public void onFreeze(CustomerEventDto dto) {
    //新对象
    CustomerVo original = dto.getOriginal();
    String onlyKey = original.getId();
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
    crmBusinessLogDto.setOnlyKey(onlyKey);
    crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    //只需要传锁定状态字段
    JSONObject oldObject =new JSONObject();
    JSONObject newObject =new JSONObject();
    oldObject.put("lockState",original.getLockState());
    newObject.put("lockState", FreezeStatusEnum.FREEZE.getCode());
    crmBusinessLogDto.setOldObject(oldObject);
    crmBusinessLogDto.setNewObject(newObject);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }

  @Override
  public void onUnfreeze(CustomerEventDto dto) {
    //新对象
    CustomerVo original = dto.getOriginal();
    String onlyKey = original.getId();
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
    crmBusinessLogDto.setOnlyKey(onlyKey);
    crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    //只需要传锁定状态字段
    JSONObject oldObject =new JSONObject();
    JSONObject newObject =new JSONObject();
    oldObject.put("lockState",original.getLockState());
    newObject.put("lockState", FreezeStatusEnum.NORMAL.getCode());
    crmBusinessLogDto.setOldObject(oldObject);
    crmBusinessLogDto.setNewObject(newObject);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }


}
