/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.local.entity.CustomerEntity;
import com.biz.crm.mdm.business.customer.local.service.CustomerDockingService;
import com.biz.crm.mdm.business.customer.local.service.CustomerService;
import com.biz.crm.mdm.business.customer.sdk.dto.BindCustomerDockingDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerRebindOrgDto;
import com.biz.crm.mdm.business.customer.sdk.dto.UnbindCustomerDockingDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/customer/customer"})
@Api(tags={"\u5ba2\u6237\u4fe1\u606f: Customer: \u5ba2\u6237\u7ba1\u7406"})
public class CustomerController {
    private static final Logger log = LoggerFactory.getLogger(CustomerController.class);
    @Autowired(required=false)
    private CustomerService customerService;
    @Autowired(required=false)
    private CustomerDockingService customerDockingService;

    @ApiOperation(value="\u65b0\u589e\u5ba2\u6237")
    @PostMapping(value={"/create"})
    public Result<?> create(@RequestBody CustomerDto dto) {
        try {
            return Result.ok((Object)((Object)this.customerService.create(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u5ba2\u6237")
    @PatchMapping(value={"/update"})
    public Result<?> update(@RequestBody CustomerDto dto) {
        try {
            return Result.ok((Object)((Object)this.customerService.update(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u5ba2\u6237")
    @PostMapping(value={"/updateTurnPatch"})
    public Result<?> updateTurnPatch(@RequestBody CustomerDto dto) {
        return Result.ok(this.update(dto));
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            this.customerService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enableBatch"})
    public Result<?> enableBatch(@RequestBody List<String> ids) {
        try {
            this.customerService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disableBatch"})
    public Result<?> disableBatch(@RequestBody List<String> ids) {
        try {
            this.customerService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u51bb\u7ed3")
    @PatchMapping(value={"/freezeBatch"})
    public Result<?> freezeBatch(@RequestBody List<String> ids) {
        try {
            this.customerService.freezeBatch(ids);
            return Result.ok((String)"\u51bb\u7ed3\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u89e3\u51bb")
    @PatchMapping(value={"/unfreezeBatch"})
    public Result<?> unfreezeBatch(@RequestBody List<String> ids) {
        try {
            this.customerService.unfreezeBatch(ids);
            return Result.ok((String)"\u89e3\u51bb\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba2\u6237\u66f4\u6362\u4f01\u4e1a\u7ec4\u7ec7")
    @PatchMapping(value={"/rebindOrg"})
    public Result<?> rebindOrg(@RequestBody CustomerRebindOrgDto dto) {
        try {
            this.customerService.rebindOrg(dto);
            return Result.ok((String)"\u66f4\u6362\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba2\u6237\u66f4\u6362\u5ba2\u6237\u7ec4\u7ec7")
    @PatchMapping(value={"/rebindCustomerOrg"})
    public Result<?> rebindCustomerOrg(@RequestBody CustomerRebindOrgDto dto) {
        try {
            this.customerService.rebindCustomerOrg(dto);
            return Result.ok((String)"\u66f4\u6362\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ed1\u5b9a\u5bf9\u63a5\u4eba")
    @PatchMapping(value={"/bindDocking"})
    public Result<?> bindDocking(@RequestBody BindCustomerDockingDto dto) {
        try {
            this.customerDockingService.bind(dto);
            return Result.ok((String)"\u7ed1\u5b9a\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u89e3\u7ed1\u5bf9\u63a5\u4eba")
    @PatchMapping(value={"/unbindDocking"})
    public Result<?> unbindDocking(@RequestBody UnbindCustomerDockingDto dto) {
        try {
            this.customerDockingService.unbind(dto);
            return Result.ok((String)"\u89e3\u7ed1\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0a\u7ea7\u5ba2\u6237\u4fe1\u606f\u4e0b\u62c9\u6846\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByParentCustomerIsNull"})
    public Result<Page<CustomerEntity>> findByParentCustomerIsNull(@PageableDefault(value=50) Pageable pageable) {
        try {
            return Result.ok(this.customerService.findByParentCustomerIsNull(pageable));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0b\u7ea7\u5ba2\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findChildrenByCustomerCode"})
    public Result<Page<CustomerEntity>> findChildrenByCustomerCode(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="customerCode", value="\u5ba2\u6237\u7f16\u7801") @RequestParam(value="customerCode") String customerCode) {
        try {
            return Result.ok(this.customerService.findChildrenByCustomerCode(pageable, customerCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u6807\u7b7eid\u67e5\u8be2")
    @GetMapping(value={"/findByTagId"})
    public Result<Page<CustomerEntity>> findByTagId(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="tagId", value="\u6807\u7b7eid") @RequestParam(value="tagId") String tagId) {
        try {
            return Result.ok(this.customerService.findByTagId(pageable, tagId));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u6216\u5ba2\u6237\u540d\u79f0\u67e5\u8be2")
    @GetMapping(value={"/findByCustomerCodeLikeOrCustomerNameLike"})
    public Result<List<CustomerEntity>> findByCustomerCodeLikeOrCustomerNameLike(@RequestParam(value="customerCodeLikeOrNameLike") String customerCodeLikeOrNameLike) {
        try {
            return Result.ok(this.customerService.findByCustomerCodeLikeOrCustomerNameLike(customerCodeLikeOrNameLike));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

