/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.local.entity.WorkflowFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.enums.FreezeStatusEnum;
import com.biz.crm.mdm.business.customer.local.entity.CustomerEntity;
import com.biz.crm.mdm.business.customer.local.mapper.CustomerMapper;
import com.biz.crm.mdm.business.customer.local.model.MultipleConditionModel;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerQueryDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerSelectDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class CustomerRepository
extends ServiceImpl<CustomerMapper, CustomerEntity> {
    private static final Integer SIZE = 1000;

    public List<CustomerEntity> findByCodes(List<String> customerCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(CustomerEntity::getCustomerCode, customerCodes)).list();
    }

    public CustomerEntity findByProcessNumber(String processNumber) {
        return (CustomerEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(WorkflowFlagOpEntity::getProcessNumber, (Object)processNumber)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus.getCode())).update();
    }

    public void freezeBatch(List<String> ids, FreezeStatusEnum freezeStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(CustomerEntity::getLockState, (Object)freezeStatus.getCode())).update();
    }

    public Page<CustomerEntity> findByCustomerSelectDto(Pageable pageable, CustomerSelectDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        return ((CustomerMapper)this.baseMapper).findByCustomerSelectDto((Page<CustomerEntity>)page, dto);
    }

    public Page<CustomerEntity> findChildrenByCustomerCode(Pageable pageable, String tenantCode, String customerCode) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((CustomerMapper)this.baseMapper).findChildrenByCustomerCode((Page<CustomerEntity>)page, tenantCode, customerCode);
    }

    public CustomerEntity findDetailsByIdOrCode(String id, String customerCode, String tenantCode) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{id, customerCode})) {
            return null;
        }
        return ((CustomerMapper)this.baseMapper).findDetailsByIdOrCode(id, customerCode, tenantCode);
    }

    public void rebindCustomerOrgCode(String orgCode, String originOrgCode, List<String> customerCodeList, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(CustomerEntity::getCustomerOrgCode, (Object)originOrgCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(CustomerEntity::getCustomerCode, customerCodeList)).set(CustomerEntity::getCustomerOrgCode, (Object)orgCode)).update();
    }

    public List<CustomerEntity> findByMultipleConditionModel(MultipleConditionModel model) {
        model.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        return ((CustomerMapper)this.baseMapper).findByMultipleConditionModel(model);
    }

    public List<CustomerEntity> findByOrgCodes(List<String> orgCodeList) {
        return ((CustomerMapper)this.baseMapper).findByOrgCodes(orgCodeList, DelFlagStatusEnum.NORMAL.getCode(), TenantUtils.getTenantCode());
    }

    public List<CustomerEntity> findByChannels(List<String> channelList, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(CustomerEntity::getChannel, channelList)).list();
    }

    public Page<CustomerEntity> findByParentCustomerIsNull(Pageable pageable, String status) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((CustomerMapper)this.baseMapper).findByParentCustomerIsNull((Page<CustomerEntity>)page, status, TenantUtils.getTenantCode());
    }

    public Page<CustomerEntity> findByTagId(Pageable pageable, String tagId) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((CustomerMapper)this.baseMapper).findByTagId((Page<CustomerEntity>)page, tagId);
    }

    public List<CustomerEntity> findByCustomerCodeLikeOrCustomerNameLike(String customerCodeLikeOrNameLike) {
        if (StringUtils.isEmpty((CharSequence)customerCodeLikeOrNameLike)) {
            return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(StringUtils.isNotEmpty((CharSequence)customerCodeLikeOrNameLike), CustomerEntity::getCustomerCode, (Object)customerCodeLikeOrNameLike)).or()).like(StringUtils.isNotEmpty((CharSequence)customerCodeLikeOrNameLike), CustomerEntity::getCustomerName, (Object)customerCodeLikeOrNameLike);
        })).list();
    }

    public List<CustomerEntity> findByStatus(String status) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getEnableStatus, (Object)status)).eq(UuidFlagOpEntity::getDelFlag, (Object)status)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<CustomerEntity> findByTypes(List<String> typeList, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(CustomerEntity::getCustomerType, typeList)).list();
    }

    public Set<String> findCustomerCodesByOrgCodesAndChannelsAndTags(List<String> orgCodes, List<String> channels, List<String> tags) {
        return ((CustomerMapper)this.baseMapper).findCustomerCodesByOrgCodesAndChannelsAndTags(orgCodes, channels, tags, TenantUtils.getTenantCode());
    }

    public List<CustomerEntity> findByAmapIds(Set<String> amapIds) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(CustomerEntity::getAmapId, amapIds)).list();
    }

    public Set<String> findByCustomerQueryDto(CustomerQueryDto dto) {
        if (CollectionUtils.isEmpty((Collection)dto.getOrgCodeSet())) {
            return this.findItemCustomerQueryDto(dto);
        }
        HashSet set = Sets.newHashSet();
        for (List item : Lists.partition((List)Lists.newArrayList((Iterable)dto.getOrgCodeSet()), (int)SIZE)) {
            dto.setOrgCodeSet((Set)Sets.newHashSet((Iterable)item));
            Set<String> cur = this.findItemCustomerQueryDto(dto);
            if (CollectionUtils.isEmpty(cur)) continue;
            set.addAll(cur);
        }
        return set;
    }

    private Set<String> findItemCustomerQueryDto(CustomerQueryDto dto) {
        if (CollectionUtils.isEmpty((Collection)dto.getCustomerCodeSet())) {
            return ((CustomerMapper)this.baseMapper).findByCustomerQueryDto(dto, TenantUtils.getTenantCode());
        }
        HashSet set = Sets.newHashSet();
        for (List item : Lists.partition((List)Lists.newArrayList((Iterable)dto.getCustomerCodeSet()), (int)SIZE)) {
            dto.setCustomerCodeSet((Set)Sets.newHashSet((Iterable)item));
            Set<String> cur = ((CustomerMapper)this.baseMapper).findByCustomerQueryDto(dto, TenantUtils.getTenantCode());
            if (!CollectionUtils.isNotEmpty(cur)) continue;
            set.addAll(cur);
        }
        return set;
    }

    public List<CustomerEntity> findCountByCreateAccountAndFromTypeAndCreateTimeScope(String createAccount, String fromType, String startDate, String endDate) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidOpEntity::getCreateAccount, (Object)createAccount)).eq(CustomerEntity::getFromType, (Object)fromType)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).between(UuidOpEntity::getCreateTime, (Object)startDate, (Object)endDate)).list();
    }

    public CustomerEntity findByCustomerCodeAndChannels(String customerCode, List<String> channelList) {
        return (CustomerEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(CustomerEntity::getCustomerCode, (Object)customerCode)).in(CustomerEntity::getChannel, channelList)).one());
    }

    public CustomerEntity findByCustomerCode(String customerCode) {
        return (CustomerEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(CustomerEntity::getCustomerCode, (Object)customerCode)).one());
    }

    public List<CustomerEntity> findByCustomer7OrgIn7OrgNotIn(String customerCode, List<String> orgCodeIn, List<String> orgCodeNotIn) {
        return ((CustomerMapper)this.baseMapper).findByCustomer7OrgIn7OrgNotIn(customerCode, orgCodeIn, orgCodeNotIn, DelFlagStatusEnum.NORMAL.getCode(), TenantUtils.getTenantCode());
    }
}

