/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.internal;

import com.biz.crm.mdm.business.customer.local.entity.CustomerBillEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerBillRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerBillService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerBillDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerBillService")
public class CustomerBillServiceImpl
implements CustomerBillService {
    @Autowired(required=false)
    private CustomerBillRepository customerBillRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void rebindCustomerCode(List<CustomerBillDto> dtoList, String customerCode) {
        Validate.notBlank((CharSequence)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        this.customerBillRepository.deleteByCustomerCode(customerCode, tenantCode);
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List entities = dtoList.stream().filter(dto -> Objects.nonNull(dto) && StringUtils.isNotBlank((CharSequence)dto.getBillCompany())).map(dto -> {
            CustomerBillEntity entity;
            entity.setBillMain(Objects.isNull((entity = (CustomerBillEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, CustomerBillEntity.class, HashSet.class, ArrayList.class, new String[0])))).getBillMain()) ? Boolean.FALSE : entity.getBillMain());
            entity.setCustomerCode(customerCode);
            entity.setTenantCode(tenantCode);
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        long count = entities.stream().filter(CustomerBillEntity::getBillMain).count();
        Validate.isTrue((count <= 1L ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4fe1\u606f\uff1a\u9ed8\u8ba4\u5f00\u7968\u4fe1\u606f\u53ea\u80fd\u6709\u4e00\u4e2a", (Object[])new Object[0]);
        Validate.isTrue((count == 1L ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4fe1\u606f\uff1a\u9ed8\u8ba4\u5f00\u7968\u4fe1\u606f\u5fc5\u987b\u6709\u4e00\u4e2a", (Object[])new Object[0]);
        this.customerBillRepository.saveBatch(entities);
    }
}

