/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.internal;

import com.biz.crm.mdm.business.customer.local.entity.CustomerContactEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerContactRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerContactService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerContactDto;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerContactVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerContactService")
public class CustomerContactServiceImpl
implements CustomerContactService {
    @Autowired(required=false)
    private CustomerContactRepository customerContactRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    private static volatile Cache<String, List<CustomerContactVo>> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CustomerContactServiceImpl() {
        if (cache != null) return;
        Class<CustomerContactServiceImpl> clazz = CustomerContactServiceImpl.class;
        synchronized (CustomerContactServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    @Transactional
    public void rebindCustomerCode(List<CustomerContactDto> dtoList, String customerCode) {
        Validate.notBlank((CharSequence)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        this.customerContactRepository.deleteByCustomerCode(customerCode, tenantCode);
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List entities = dtoList.stream().filter(dto -> Objects.nonNull(dto) && StringUtils.isNotEmpty((CharSequence)dto.getContactName())).map(dto -> {
            CustomerContactEntity entity;
            entity.setContactMain(Objects.isNull((entity = (CustomerContactEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, CustomerContactEntity.class, HashSet.class, ArrayList.class, new String[0])))).getContactMain()) ? Boolean.FALSE : entity.getContactMain());
            entity.setCustomerCode(customerCode);
            entity.setTenantCode(tenantCode);
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        long count = entities.stream().filter(CustomerContactEntity::getContactMain).count();
        Validate.isTrue((count <= 1L ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4fe1\u606f\uff1a\u4e3b\u8054\u7cfb\u4eba\u53ea\u80fd\u6709\u4e00\u4e2a", (Object[])new Object[0]);
        Validate.isTrue((count == 1L ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4fe1\u606f\uff1a\u4e3b\u8054\u7cfb\u4eba\u5fc5\u987b\u6709\u4e00\u4e2a", (Object[])new Object[0]);
        this.customerContactRepository.saveBatch(entities);
    }

    @Override
    public List<CustomerContactVo> findByCustomerCodes(List<String> customerCodes) {
        if (CollectionUtils.isEmpty(customerCodes)) {
            return Lists.newArrayList();
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), customerCodes});
        List graph = (List)cache.getIfPresent((Object)cacheKey);
        if (graph != null) {
            return graph;
        }
        List<CustomerContactEntity> contactEntities = this.customerContactRepository.findByCustomerCodes(customerCodes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(contactEntities)) {
            return Lists.newArrayList();
        }
        graph = (List)this.nebulaToolkitService.copyCollectionByBlankList(contactEntities, CustomerContactEntity.class, CustomerContactVo.class, HashSet.class, ArrayList.class, new String[0]);
        cache.put((Object)cacheKey, (Object)graph);
        return graph;
    }
}

