/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.mdm.business.customer.local.entity.CustomerDockingEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerDockingRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerDockingService;
import com.biz.crm.mdm.business.customer.local.service.CustomerDockingSupplyService;
import com.biz.crm.mdm.business.customer.sdk.dto.BindCustomerDockingDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerDockingDto;
import com.biz.crm.mdm.business.customer.sdk.dto.UnbindCustomerDockingDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerDockingService")
public class CustomerDockingServiceImpl
implements CustomerDockingService {
    @Autowired(required=false)
    private CustomerDockingRepository customerDockingRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerDockingSupplyService customerDockingSupplyService;

    @Override
    @Transactional
    public void rebindCustomerCode(List<CustomerDockingDto> dtoList, String customerCode) {
        Validate.notBlank((CharSequence)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List<CustomerDockingEntity> list = this.customerDockingRepository.findByCustomerCode(customerCode, tenantCode);
        if (CollectionUtils.isNotEmpty(list)) {
            List<String> dockingIds = list.stream().map(UuidEntity::getId).collect(Collectors.toList());
            this.customerDockingRepository.removeByIds(dockingIds);
            this.customerDockingSupplyService.deleteByDockingIds(dockingIds);
        }
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        if (CollectionUtils.isEmpty(dtoList = dtoList.stream().filter(dto -> Objects.nonNull(dto) && StringUtils.isNotEmpty((CharSequence)dto.getPositionCode())).collect(Collectors.toList()))) {
            return;
        }
        Set dtoSet = dtoList.stream().map(CustomerDockingDto::getPositionCode).collect(Collectors.toSet());
        Validate.isTrue((dtoSet.size() == dtoList.size() ? 1 : 0) != 0, (String)"\u5f53\u524d\u804c\u4f4d\u5df2\u7ecf\u662f\u5bf9\u63a5\u4eba\uff0c\u8bf7\u66f4\u6362\u4e3a\u5176\u4ed6\u804c\u4f4d", (Object[])new Object[0]);
        dtoList.forEach(dto -> {
            CustomerDockingEntity entity = (CustomerDockingEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, CustomerDockingEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setCustomerCode(customerCode);
            entity.setTenantCode(tenantCode);
            this.customerDockingRepository.save((Object)entity);
            this.customerDockingSupplyService.bindDockingId(dto.getMdmCustomerSupplyDetailList(), entity.getId());
        });
    }

    @Override
    @Transactional
    public void bind(BindCustomerDockingDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getCustomerCodeList()), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPositionCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List<CustomerDockingEntity> list = this.customerDockingRepository.findByCustomerCodesAndPositionCode(dto.getCustomerCodeList(), dto.getPositionCode(), tenantCode);
        if (CollectionUtils.isNotEmpty(list)) {
            List existCustomerCodes = list.stream().map(CustomerDockingEntity::getCustomerCode).collect(Collectors.toList());
            dto.setCustomerCodeList(dto.getCustomerCodeList().stream().filter(s -> !existCustomerCodes.contains(s)).collect(Collectors.toList()));
        }
        if (CollectionUtils.isEmpty((Collection)dto.getCustomerCodeList())) {
            return;
        }
        List entities = dto.getCustomerCodeList().stream().map(customerCode -> {
            CustomerDockingEntity entity = new CustomerDockingEntity();
            entity.setTenantCode(tenantCode);
            entity.setCustomerCode((String)customerCode);
            entity.setPositionCode(dto.getPositionCode());
            return entity;
        }).collect(Collectors.toList());
        this.customerDockingRepository.saveBatch(entities);
    }

    @Override
    @Transactional
    public void unbind(UnbindCustomerDockingDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getCustomerCodeList()), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPositionCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801", (Object[])new Object[0]);
        List<CustomerDockingEntity> list = this.customerDockingRepository.findByCustomerCodesAndPositionCode(dto.getCustomerCodeList(), dto.getPositionCode(), TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<String> dockingIds = list.stream().map(UuidEntity::getId).collect(Collectors.toList());
        this.customerDockingRepository.removeByIds(dockingIds);
        this.customerDockingSupplyService.deleteByDockingIds(dockingIds);
    }
}

