/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.notifier;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.enums.FreezeStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerEventDto;
import com.biz.crm.mdm.business.customer.sdk.event.CustomerEventListener;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerLogEventListenerImpl
implements CustomerEventListener {
    @Autowired(required=false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    public void onCreate(CustomerEventDto eventDto) {
        CustomerVo newest = eventDto.getNewest();
        CustomerVo original = eventDto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)original);
        crmBusinessLogDto.setNewObject((Object)newest);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onCreateAndSubmit(CustomerEventDto dto) {
        CustomerVo original = dto.getOriginal();
        if (Objects.isNull(original)) {
            this.onCreate(dto);
        } else {
            this.onUpdate(dto);
        }
    }

    public void onDelete(CustomerEventDto eventDto) {
        CustomerVo newest = eventDto.getNewest();
        CustomerVo original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)original);
        crmBusinessLogDto.setNewObject((Object)newest);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onUpdate(CustomerEventDto eventDto) {
        CustomerVo newest = eventDto.getNewest();
        CustomerVo original = eventDto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)original);
        crmBusinessLogDto.setNewObject((Object)newest);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onDisable(CustomerEventDto dto) {
        CustomerVo original = dto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("enableStatus", (Object)original.getEnableStatus());
        newObject.put("enableStatus", (Object)EnableStatusEnum.DISABLE.getCode());
        crmBusinessLogDto.setOldObject((Object)oldObject);
        crmBusinessLogDto.setNewObject((Object)newObject);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onEnable(CustomerEventDto dto) {
        CustomerVo original = dto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("enableStatus", (Object)original.getEnableStatus());
        newObject.put("enableStatus", (Object)EnableStatusEnum.ENABLE.getCode());
        crmBusinessLogDto.setOldObject((Object)oldObject);
        crmBusinessLogDto.setNewObject((Object)newObject);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onFreeze(CustomerEventDto dto) {
        CustomerVo original = dto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("lockState", (Object)original.getLockState());
        newObject.put("lockState", (Object)FreezeStatusEnum.FREEZE.getCode());
        crmBusinessLogDto.setOldObject((Object)oldObject);
        crmBusinessLogDto.setNewObject((Object)newObject);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onUnfreeze(CustomerEventDto dto) {
        CustomerVo original = dto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("lockState", (Object)original.getLockState());
        newObject.put("lockState", (Object)FreezeStatusEnum.NORMAL.getCode());
        crmBusinessLogDto.setOldObject((Object)oldObject);
        crmBusinessLogDto.setNewObject((Object)newObject);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}

