package com.biz.crm.mdm.business.customer.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.local.entity.CustomerAddressEntity;
import com.biz.crm.mdm.business.customer.local.service.CustomerAddressService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerAddressDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 客户信息: CustomerAddress: 客户收货地址管理
 *
 * @author ning.zhang
 * @date 2021-10-28 17:48:59
 */
@Slf4j
@Api(tags = "客户信息: CustomerAddress: 客户收货地址管理")
@RestController
@RequestMapping(value = {"/v1/customerAddress/customerAddress"})
public class CustomerAddressController {

  @Autowired(required = false)
  private CustomerAddressService customerAddressService;


  @ApiOperation(value = "新增客户收货地址")
  @PostMapping(value = "/create")
  public Result<CustomerAddressEntity> create(@RequestBody CustomerAddressDto dto) {
    try {
      return Result.ok(this.customerAddressService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新客户收货地址")
  @PatchMapping(value = "/update")
  public Result<CustomerAddressEntity> update(@RequestBody CustomerAddressDto dto) {
    try {
      return Result.ok(this.customerAddressService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result<?> deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.customerAddressService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
