package com.biz.crm.mdm.business.customer.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.local.entity.CustomerEntity;
import com.biz.crm.mdm.business.customer.local.service.CustomerDockingService;
import com.biz.crm.mdm.business.customer.local.service.CustomerGroupService;
import com.biz.crm.mdm.business.customer.local.service.CustomerService;
import com.biz.crm.mdm.business.customer.sdk.dto.BindCustomerDockingDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerRebindOrgDto;
import com.biz.crm.mdm.business.customer.sdk.dto.UnbindCustomerDockingDto;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerGroupVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 客户信息: Customer: 客户管理
 *
 * @author ning.zhang
 * @date 2021/10/15
 */
@Slf4j
@RestController
@RequestMapping("/v1/customerGroup/customerGroup")
@Api(tags = "客户组: customerGroup: 客户组")
public class CustomerGroupController {


  @Autowired(required = false)
  private CustomerGroupService customerGroupService;

  @ApiOperation(value = "新增客户")
  @PostMapping("/create")
  public Result create(@RequestBody CustomerGroupVo customerGroupVo) {
    try {
      this.customerGroupService.create(customerGroupVo);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新客户")
  @PatchMapping("/update")
  public Result<?> update(@RequestBody CustomerGroupVo customerGroupVo) {
    try {
      this.customerGroupService.modify(customerGroupVo);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "客户组详情")
  @GetMapping("/detail")
  public Result<CustomerGroupVo> detail(@RequestParam("id") String id) {
    try {
      CustomerGroupVo customerGroupVo= this.customerGroupService.detail(id);
      return Result.ok(customerGroupVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result<?> deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.customerGroupService.delete(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }





}
