package com.biz.crm.mdm.business.customer.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.WorkflowFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.LoginFromTypeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 客户实体类
 *
 * @author ning.zhang
 * @date 2021/10/25
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerEntity", description = "客户实体")
@Entity
@TableName("mdm_customer")
@Table(
    name = "mdm_customer",
    indexes = {
        @Index(name = "mdm_customer_index1", columnList = "customer_code"),
        @Index(name = "mdm_customer_index2", columnList = "tenant_code,del_flag, create_time, customer_code", unique = true),
    })
@org.hibernate.annotations.Table(appliesTo = "mdm_customer", comment = "客户表")
public class CustomerEntity extends WorkflowFlagOpEntity {

  private static final long serialVersionUID = -2379135367765734248L;

  /**
   * 高德地图ID
   */
  @ApiModelProperty("高德地图ID")
  @Column(name = "amap_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '高德地图ID'")
  private String amapId;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  @Column(name = "channel", length = 64, columnDefinition = "VARCHAR(64) COMMENT '渠道'")
  private String channel;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户编码'")
  private String customerCode;

  /**
   * 客户组织编码
   */
  @ApiModelProperty("客户组织编码")
  @Column(
      name = "customer_org_code",
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT '客户组织编码'")
  private String customerOrgCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  @Column(name = "customer_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
  private String customerName;

  /**
   * 客户类型
   */
  @ApiModelProperty("客户类型")
  @Column(name = "customer_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户类型'")
  private String customerType;

  /**
   * 操作类型
   */
  @ApiModelProperty("操作类型")
  @Column(name = "operate_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '操作类型'")
  private String operateType;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  @Column(name = "city_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '市编码'")
  private String cityCode;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  @Column(name = "district_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '区编码'")
  private String districtCode;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  @Column(name = "province_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '省编码'")
  private String provinceCode;

  /**
   * 注册地址
   */
  @ApiModelProperty("注册地址")
  @Column(
      name = "registered_address",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '注册地址'")
  private String registeredAddress;

  /**
   * 工程名
   */
  @ApiModelProperty("工程名")
  @Column(name = "project_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '工程名'")
  private String projectName;

  /**
   * 客户联系方式
   */
  @ApiModelProperty("客户联系方式")
  @Column(
      name = "customer_contact",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '客户联系方式'")
  private String customerContact;

  /**
   * 客户法人代表
   */
  @ApiModelProperty("客户法人代表")
  @Column(
      name = "legal_representative",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '客户法人代表'")
  private String legalRepresentative;

  /**
   * 锁定状态：009正常，003冻结
   */
  @ApiModelProperty("锁定状态：009正常，003冻结")
  @Column(
      name = "lock_state",
      length = 8,
      columnDefinition = "VARCHAR(8) COMMENT '锁定状态：009正常，003冻结'")
  private String lockState;

  /**
   * 经度
   */
  @ApiModelProperty("经度")
  @Column(name = "longitude", columnDefinition = "decimal(12,8) COMMENT '经度'")
  private BigDecimal longitude;

  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  @Column(name = "latitude", columnDefinition = "decimal(12,8) COMMENT '纬度'")
  private BigDecimal latitude;

  /**
   * erp编码
   */
  @ApiModelProperty("erp编码")
  @Column(name = "erp_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'erp编码'")
  private String erpCode;

  /**
   * 审批状态
   */
  @ApiModelProperty("审批状态")
  @Column(name = "act_approve_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT '审批状态'")
  private String actApproveStatus;

  /**
   * 价格组
   */
  @ApiModelProperty("价格组")
  @Column(name = "price_group", length = 64, columnDefinition = "VARCHAR(64) COMMENT '价格组'")
  private String priceGroup;

  /**
   * 合作状态
   */
  @ApiModelProperty("合作状态")
  @Column(name = "cooperate_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT '合作状态'")
  private String cooperateStatus;

  /**
   * 审批类型
   */
  @ApiModelProperty("审批类型")
  @Column(name = "approval_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '审批类型'")
  private String approvalType;

  /**
   * 流程编号
   */
  @ApiModelProperty("流程编号")
  @Column(name = "process_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '流程编号'")
  private String processCode;

  /**
   * 数据来源
   */
  @ApiModelProperty("数据来源")
  @Column(name = "source_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据来源'")
  private String sourceType;

  /**
   * 业务来源系统
   *
   * @see LoginFromTypeEnum#getValue()
   */
  @ApiModelProperty("业务来源系统")
  @Column(name = "from_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务来源系统'")
  private String fromType;

  /**
   * 是否分利 true/false
   * 可能为空，为空则默认为false
   */
  @ApiModelProperty("是否分利")
  @TableField(value = "share_benefits")
  @Column(name = "share_benefits", columnDefinition = "int COMMENT '是否分利'")
  private Boolean shareBenefits;

  /**
   * 设置为分利终端时间
   */
  @ApiModelProperty("设置为分利终端时间")
  @TableField(value = "share_benefits_time")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "share_benefits_time", columnDefinition = "int COMMENT '设置为分利终端时间'")
  private Date shareBenefitsTime;

  /**
   * 关联对接人信息
   */
  @ApiModelProperty("关联对接人信息")
  @Transient
  @TableField(exist = false)
  private List<CustomerDockingEntity> dockingList;

  /**
   * 关联联系人信息
   */
  @ApiModelProperty("关联联系人信息")
  @Transient
  @TableField(exist = false)
  private List<CustomerContactEntity> contactList;

  /**
   * 关联销售区域信息
   */
  @ApiModelProperty("关联销售区域信息")
  @Transient
  @TableField(exist = false)
  private List<CustomerSaleAreaEntity> saleAreaList;

  /**
   * 关联开票信息
   */
  @ApiModelProperty("关联开票信息")
  @Transient
  @TableField(exist = false)
  private List<CustomerBillEntity> billList;

  /**
   * 关联文件信息(证件上传照片/法人身份上传照片)
   */
  @ApiModelProperty("关联文件信息(证件上传照片/法人身份上传照片)")
  @Transient
  @TableField(exist = false)
  private List<CustomerMediaEntity> fileList;

  /**
   * 组织编码-占位
   */
  @ApiModelProperty("组织编码-占位")
  @Transient
  @TableField(exist = false)
  private String orgCode;

  /**
   * 客户与企业组织关联信息
   */
  @ApiModelProperty("客户与企业组织关联信息")
  @Transient
  @TableField(exist = false)
  private List<CustomerROrgEntity> orgList;


  @ApiModelProperty("客户与销售区域信息")
  @Transient
  @TableField(exist = false)
  private List<DealerSalesRegionEntity> dealerSalesRegionEntityList;


  @ApiModelProperty("采供关系")
  @Transient
  @TableField(exist = false)
  private List<SupplyRelationshipEntity> supplyRelationshipEntityList;

  /**
   * 客户等级
   */
  @ApiModelProperty("客户等级")
  @Column(name = "customer_level", length = 10, columnDefinition = "VARCHAR(10) COMMENT '客户等级'")
  private String customerLevel;

  /**
   * 上级经销商编码
   */
  @ApiModelProperty("上级经销商编码")
  @Column(
      name = "parent_customer_code",
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT '上级经销商编码'")
  private String parentCustomerCode;

  @ApiModelProperty(value ="经销商id（EAS）")
  @Column(name = "sources_id", length = 32, columnDefinition = "VARCHAR(32) COMMENT '经销商id（EAS）'")
  private String sourcesId;

  @ApiModelProperty(value ="经销商id（兆信）")
  @Column(name = "dealer_id", length = 32, columnDefinition = "VARCHAR(32) COMMENT '经销商id（兆信）'")
  private String dealerId;

  @ApiModelProperty(value ="经销商渠道类型")
  @Column(name = "dealer_type", length = 10, columnDefinition = "VARCHAR(10) COMMENT '经销商渠道类型'")
  private String dealerType;

  @ApiModelProperty(value ="经销商分类id")
  @Column(name = "dealer_classify_id", length = 32, columnDefinition = "VARCHAR(32) COMMENT '经销商分类id'")
  private String dealerClassifyId;

  @ApiModelProperty(value ="经销商分类名称")
  @Column(name = "dealer_classify_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '经销商分类名称'")
  private String dealerClassifyName;

  @ApiModelProperty(value ="签约类型")
  @Column(name = "sign_type", length = 100, columnDefinition = "VARCHAR(100) COMMENT '签约类型'")
  private String signType;

  @ApiModelProperty(value ="经销商等级id")
  @Column(name = "dealer_level_id", length = 32, columnDefinition = "VARCHAR(32) COMMENT '经销商等级id'")
  private String dealerLevelId;

  @ApiModelProperty(value ="经销商等级名称")
  @Column(name = "dealer_level_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '经销商等级名称'")
  private String DealerLevelName;

  @ApiModelProperty(value ="联系人")
  @Column(name = "contact_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '联系人'")
  private String contactName;

  @ApiModelProperty(value ="电话")
  @Column(name = "phone", length = 64, columnDefinition = "VARCHAR(64) COMMENT '电话'")
  private String phone;

  @ApiModelProperty(value ="经销商身份")
  @Column(name = "channel_level", length = 64, columnDefinition = "VARCHAR(64) COMMENT '经销商身份'")
  private String channelLevel;

  @ApiModelProperty(value ="状态")
  @Column(name = "status", length = 10, columnDefinition = "VARCHAR(10) COMMENT '状态'")
  private String status;

  @ApiModelProperty(value ="省")
  @Column(name = "province", length = 32, columnDefinition = "VARCHAR(32) COMMENT '省'")
  private String province;

  @ApiModelProperty(value ="市")
  @Column(name = "city", length = 32, columnDefinition = "VARCHAR(32) COMMENT '市'")
  private String city;

  @ApiModelProperty(value ="县区/市县")
  @Column(name = "district", length = 32, columnDefinition = "VARCHAR(32) COMMENT '县区/市县'")
  private String district;

  @ApiModelProperty(value ="省名字")
  @Column(name = "province_name", length = 32, columnDefinition = "VARCHAR(32) COMMENT '省名字'")
  private String provinceName;

  @ApiModelProperty(value ="市名字")
  @Column(name = "city_name", length = 32, columnDefinition = "VARCHAR(32) COMMENT '市名字'")
  private String cityName;

  @ApiModelProperty(value ="县区/市县名字")
  @Column(name = "district_name", length = 32, columnDefinition = "VARCHAR(32) COMMENT '县区/市县名字'")
  private String districtName;

  @ApiModelProperty(value ="详细地址")
  @Column(name = "address_detail", length = 128, columnDefinition = "VARCHAR(128) COMMENT '详细地址'")
  private String addressDetail;

  @ApiModelProperty(value ="渠道类型")
  @Column(name = "channel_type", length = 10, columnDefinition = "VARCHAR(10) COMMENT '渠道类型'")
  private String channelType;

  @ApiModelProperty(value ="渠道分类")
  @Column(name = "channel_category", length = 10, columnDefinition = "VARCHAR(10) COMMENT '渠道分类'")
  private String channelCategory;

  @ApiModelProperty(value ="渠道等级")
  @Column(name = "channel_level_code", length = 10, columnDefinition = "VARCHAR(10) COMMENT '渠道等级'")
  private String channelLevelCode;

  @ApiModelProperty(value = "经销商销售区域")
  @Column(name = "area_type", length = 128, columnDefinition = "VARCHAR(128) COMMENT '经销商销售区域'")
  private String areaType;

  @ApiModelProperty(value ="助记码")
  @Column(name = "mnemonic_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '助记码'")
  private String mnemonicCode;

}
