package com.biz.crm.mdm.business.customer.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 客户组明细
 *
 * @author lgq
 * @date 20203-06-13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_group_detail")
@Table(name = "mdm_customer_group_detail")
@ApiModel("客户组明细")
@Entity
@org.hibernate.annotations.Table(appliesTo = "mdm_customer_group_detail", comment = "客户组明细")
public class CustomerGroupDetailEntity extends UuidEntity {


  @TableField(value = "customer_groups_code")
  @Column(name = "customer_groups_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户组编码'")
  @ApiModelProperty("客户组编码")
  private String customerGroupsCode;


  @TableField(value = "sourse_id")
  @Column(name = "sourse_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '经销商id（EAS）'")
  @ApiModelProperty(value = "经销商id（EAS）")
  private String sourseId;

  @TableField(value = "dealer_id")
  @Column(name = "dealer_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '经销商id（兆信）'")
  @ApiModelProperty(value = "经销商id（兆信）")
  private String dealerId;

  @TableField(value = "dealer_code")
  @Column(name = "dealer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '经销商编码'")
  @ApiModelProperty(value = "经销商编码")
  private String dealerCode;


  @TableField(value = "dealer_name")
  @Column(name = "dealer_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '经销商名称'")
  @ApiModelProperty(value = "经销商名称")
  private String dealerName;


}
