package com.biz.crm.mdm.business.customer.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 组织表实体类
 *
 * @author lgq
 * @date 20203-06-13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_group")
@Table(name = "mdm_customer_group")
@ApiModel("客户组实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "mdm_customer_group", comment = "客户组")
public class CustomerGroupEntity extends TenantFlagOpEntity {

  @TableField(value = "customer_groups_code")
  @Column(name = "customer_groups_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户组编码'")
  @ApiModelProperty("客户组编码")
  private String customerGroupsCode;

  @TableField(value = "customer_groups_name")
  @Column(name = "customer_groups_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '客户组编码'")
  @ApiModelProperty("客户组名称")
  private String customerGroupsName;

  @ApiModelProperty(value = "经销商数量")
  @TableField(value = "dealer_num")
  @Column(name = "dealer_num", length = 64, columnDefinition = "VARCHAR(64) COMMENT '经销商数量'")
  private String dealerNum;


  @ApiModelProperty(value = "分类标准")
  @TableField(value = "classify_standard")
  @Column(name = "classify_standard", length = 64, columnDefinition = "VARCHAR(64) COMMENT '分类标准'")
  private String classifyStandard;


  @TableField(value = "status")
  @Column(name = "status", length = 64, columnDefinition = "VARCHAR(64) COMMENT '外部接口传入状态'")
  @ApiModelProperty(value = "状态")
  private String status;

  @TableField(value = "opt")
  @Column(name = "opt", length = 6, columnDefinition = "VARCHAR(6) COMMENT '外部接口传入操作类型'")
  @ApiModelProperty(value = "外部接口传入操作类型")
  private String opt;

}
