package com.biz.crm.mdm.business.customer.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 客户与企业组织关联表实体类
 *
 * @author ning.zhang
 * @date 2021/11/10
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerROrgEntity", description = "客户与企业组织关联表实体类")
@Entity
@TableName("mdm_customer_r_org")
@Table(name = "mdm_customer_r_org", indexes = {
    @Index(name = "mdm_customer_r_org_index1", columnList = "customer_code"),
    @Index(name = "mdm_customer_r_org_index2", columnList = "org_code")
})
@org.hibernate.annotations.Table(appliesTo = "mdm_customer_r_org", comment = "客户表")
public class CustomerROrgEntity extends TenantEntity {


  private static final long serialVersionUID = -4535359817780910274L;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户编码'")
  private String customerCode;

  /**
   * 企业组织编码
   */
  @ApiModelProperty("企业组织编码")
  @Column(name = "org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '企业组织编码'")
  private String orgCode;

  @ApiModelProperty(value = "关联组织id（EAS）")
  @Column(name = "sources_org_id", length = 32, columnDefinition = "varchar(32) COMMENT '关联组织id（EAS）'")
  private String sourcesOrgId;

  @ApiModelProperty(value = "关联组织id(兆信)")
  @Column(name = "relation_org_id", length = 32, columnDefinition = "varchar(32) COMMENT '关联组织id(兆信)'")
  private String relationOrgId;

  @ApiModelProperty(value = "关联组织编码")
  @Column(name = "relation_org_code", length = 32, columnDefinition = "varchar(32) COMMENT '关联组织编码'")
  private String relationOrgCode;

  @ApiModelProperty(value = "关联组织名称")
  @Column(name = "relation_org_name", length = 128, columnDefinition = "varchar(128) COMMENT '关联组织名称'")
  private String relationOrgName;

  @ApiModelProperty(value = "状态")
  @Column(name = "status", length = 10, columnDefinition = "varchar(10) COMMENT '状态'")
  private String status;

  @ApiModelProperty(value = "经销商id（EAS）")
  @Column(name = "sources_id", length = 32, columnDefinition = "varchar(32) COMMENT '经销商id（EAS）'")
  private String sourcesId;
  @ApiModelProperty(value = "经销商id（兆信）")
  @Column(name = "dealer_id", length = 32, columnDefinition = "varchar(32) COMMENT '经销商id（兆信）'")
  private String dealerId;

  @ApiModelProperty(value = "经销商编码")
  @Column(name = "dealer_code", length = 32, columnDefinition = "varchar(32) COMMENT '经销商编码'")
  private String dealerCode;

  @ApiModelProperty(value = "经销商名称")
  @Column(name = "dealer_name", length = 128, columnDefinition = "varchar(128) COMMENT '经销商名称'")
  private String dealerName;

}
