package com.biz.crm.mdm.business.customer.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标签规则表
 * @Author: zengxingwang
 * @Date: 2021/12/21 14:30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerTagRuleEntity", description = "标签规则实体")
@Entity
@TableName("mdm_customer_tag_rule")
@Table(name = "mdm_customer_tag_rule")
@org.hibernate.annotations.Table(appliesTo = "mdm_customer_tag_rule", comment = "标签规则表")
public class CustomerTagRuleEntity extends TenantEntity {
  private static final long serialVersionUID = -1453927111221321212L;

  /**
   * 标签id
   */
  @ApiModelProperty("标签id")
  @Column(name = "customer_tag_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '标签id'")
  private String customerTagId;

  /**
   * 标签属性
   */
  @ApiModelProperty("标签属性")
  @Column(name = "tag_attributes", length = 64, columnDefinition = "VARCHAR(64) COMMENT '标签属性'")
  private String tagAttributes;

  /**
   * 标签细分
   */
  @ApiModelProperty("标签细分")
  @Column(name = "tag_subdivision", length = 64, columnDefinition = "VARCHAR(64) COMMENT '标签细分'")
  private String tagSubdivision;

  /**
   * 标签表达式
   */
  @ApiModelProperty("标签表达式")
  @Column(name = "tag_expression", length = 64, columnDefinition = "VARCHAR(64) COMMENT '标签表达式'")
  private String tagExpression;

  /**
   * 表达式结果（0：否；1：是；）
   */
  @ApiModelProperty("表达式结果（0：否；1：是；）")
  @Column(name = "expression_result", length = 1, columnDefinition = "int(1) COMMENT '表达式结果（0：否；1：是；）'")
  private Boolean expressionResult;

  /**
   * 表达式数量
   */
  @ApiModelProperty("表达式数量")
  @Column(name = "expression_amount", columnDefinition = "decimal(20,4) COMMENT '表达式数量'")
  private BigDecimal expressionAmount;

  /**
   * 表达式数量
   */
  @ApiModelProperty("表达式数量")
  @Column(name = "expression_amount_max", columnDefinition = "decimal(20,4) COMMENT '表达式数量'")
  private BigDecimal expressionAmountMax;

  /**
   * 统计时间开始
   */
  @ApiModelProperty("统计时间开始")
  @Column(name = "begin_time", columnDefinition = "datetime COMMENT '统计时间开始'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date beginTime;

  /**
   * 统计时间结束
   */
  @ApiModelProperty("统计时间结束")
  @Column(name = "end_time", columnDefinition = "datetime COMMENT '统计时间结束'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;

}
