package com.biz.crm.mdm.business.customer.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @ClassName DealerOrgRelationshipReqVo
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/14 10:15
 **/
@Data
@ApiModel("经销商与组织关联关系")
@Entity
@TableName("mdm_dealer_org_relationship")
@Table(name = "mdm_dealer_org_relationship")
@org.hibernate.annotations.Table(appliesTo = "mdm_dealer_org_relationship", comment = "经销商与组织关联关系")
public class DealerOrgRelationshipEntity extends TenantFlagOpEntity {

    @ApiModelProperty(value = "关联组织id（EAS）")
    @Column(name = "sources_org_id", length = 32, columnDefinition = "varchar(32) COMMENT '关联组织id（EAS）'")
    private String sourcesOrgId;

    @ApiModelProperty(value = "关联组织id(兆信)")
    @Column(name = "relation_org_id", length = 32, columnDefinition = "varchar(32) COMMENT '关联组织id(兆信)'")
    private String relationOrgId;

    @ApiModelProperty(value = "关联组织编码")
    @Column(name = "relation_org_code", length = 32, columnDefinition = "varchar(32) COMMENT '关联组织编码'")
    private String relationOrgCode;

    @ApiModelProperty(value = "关联组织名称")
    @Column(name = "relation_org_name", length = 128, columnDefinition = "varchar(128) COMMENT '关联组织名称'")
    private String relationOrgName;

    @ApiModelProperty(value = "状态")
    @Column(name = "status", length = 10, columnDefinition = "varchar(10) COMMENT '状态'")
    private String status;

    @ApiModelProperty(value = "经销商id（EAS）")
    @Column(name = "sources_id", length = 32, columnDefinition = "varchar(32) COMMENT '经销商id（EAS）'")
    private String sourcesId;
    @ApiModelProperty(value = "经销商id（兆信）")
    @Column(name = "dealer_id", length = 32, columnDefinition = "varchar(32) COMMENT '经销商id（兆信）'")
    private String dealerId;

    @ApiModelProperty(value = "经销商编码")
    @Column(name = "dealer_code", length = 32, columnDefinition = "varchar(32) COMMENT '经销商编码'")
    private String dealerCode;

    @ApiModelProperty(value = "经销商名称")
    @Column(name = "dealer_name", length = 128, columnDefinition = "varchar(128) COMMENT '经销商名称'")
    private String dealerName;

}
