package com.biz.crm.mdm.business.customer.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @ClassName DealerSalesRegionReqVo
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/14 10:51
 **/
@Data
@ApiModel("经销商销售区域")
@Entity
@TableName("mdm_dealer_sales_region")
@Table(name = "mdm_dealer_sales_region")
@org.hibernate.annotations.Table(appliesTo = "mdm_dealer_sales_region", comment = "经销商销售区域")
public class DealerSalesRegionEntity extends TenantFlagOpEntity {

    @ApiModelProperty(value = "经销商id（EAS）")
    @Column(name = "sources_id", length = 32, columnDefinition = "varchar(32) COMMENT '经销商id（EAS）'")
    private String sourcesId;

    @ApiModelProperty(value = "经销商id（兆信）")
    @Column(name = "dealer_id", length = 32, columnDefinition = "varchar(32) COMMENT '经销商id（兆信）'")
    private String dealerId;

    @ApiModelProperty(value = "经销商编码")
    @Column(name = "dealer_code", length = 32, columnDefinition = "varchar(32) COMMENT '经销商编码'")
    private String dealerCode;

    @ApiModelProperty(value = "经销商名称")
    @Column(name = "dealer_name", length = 128, columnDefinition = "varchar(128) COMMENT '经销商名称'")
    private String dealerName;

    @ApiModelProperty(value = "经销区域类型")
    @Column(name = "area_type", length = 10, columnDefinition = "varchar(10) COMMENT '经销区域类型'")
    private String areaType;

    @ApiModelProperty(value = "经销范围（省）")
    @Column(name = "province", length = 32, columnDefinition = "varchar(32) COMMENT '经销范围（省）'")
    private String province;

    @ApiModelProperty(value = "经销范围（市）")
    @Column(name = "city", length = 32, columnDefinition = "varchar(32) COMMENT '经销范围（市）'")
    private String city;

    @ApiModelProperty(value = "经销范围（区县/市区）")
    @Column(name = "district", length = 32, columnDefinition = "varchar(32) COMMENT '经销范围（区县/市区）'")
    private String district;

    @ApiModelProperty(value = "经销范围（乡镇/街道）")
    @Column(name = "town", length = 32, columnDefinition = "varchar(32) COMMENT '经销范围（乡镇/街道）'")
    private String town;

    @ApiModelProperty(value = "省名字")
    @Column(name = "province_name", length = 32, columnDefinition = "varchar(32) COMMENT '省名字'")
    private String provinceName;

    @ApiModelProperty(value = "市名字")
    @Column(name = "city_name", length = 32, columnDefinition = "varchar(32) COMMENT '市名字'")
    private String cityName;

    @ApiModelProperty(value = "区名字")
    @Column(name = "district_name", length = 128, columnDefinition = "varchar(128) COMMENT '区名字'")
    private String districtName;

    @ApiModelProperty(value = "乡镇名字")
    @Column(name = "town_name", length = 128, columnDefinition = "varchar(128) COMMENT '乡镇名字'")
    private String townName;

}
