package com.biz.crm.mdm.business.customer.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @ClassName DealerSupplyRelationshipDetailReqVo
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/13 16:48
 **/
@Data
@ApiModel("采供关系关联明细")
@Entity
@TableName("mdm_supply_relationship_detail")
@Table(name = "mdm_supply_relationship_detail")
@org.hibernate.annotations.Table(appliesTo = "mdm_supply_relationship_detail", comment = "采供信息明细表")
public class SupplyRelationshipDetailEntity extends TenantFlagOpEntity {

    @ApiModelProperty(value = "采供关系ID")
    @Column(name = "supply_relationship_id", length = 32, columnDefinition = "varchar(32) COMMENT '采供关系ID'")
    private String supplyRelationshipId;

    @ApiModelProperty(value = "产品分类编码")
    @Column(name = "product_classify_code", length = 32, columnDefinition = "varchar(32) COMMENT '产品分类编码'")
    private String productClassifyCode;

    @ApiModelProperty(value = "产品分类名称")
    @Column(name = "product_classify_name", length = 64, columnDefinition = "varchar(64) COMMENT '产品分类名称'")
    private String productClassifyName;

    @ApiModelProperty(value = "产品id")
    @Column(name = "product_id", length = 32, columnDefinition = "varchar(32) COMMENT '产品id'")
    private String productId;

    @ApiModelProperty(value = "产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty(value = "产品名称")
    @Column(name = "product_name", length = 128, columnDefinition = "varchar(128) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty(value = "产品规格")
    @Column(name = "product_spe", length = 32, columnDefinition = "varchar(32) COMMENT '产品规格'")
    private String productSpe;

    @ApiModelProperty(value = "产品状态")
    @Column(name = "product_status", length = 10, columnDefinition = "varchar(10) COMMENT '产品状态'")
    private String productStatus;

}
