package com.biz.crm.mdm.business.customer.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @ClassName DealerSupplyRelationshipReqVo
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/13 16:26
 **/
@Data
@ApiModel("采供信息同步表")
@Entity
@TableName("mdm_supply_relationship")
@Table(name = "mdm_supply_relationship")
@org.hibernate.annotations.Table(appliesTo = "mdm_supply_relationship", comment = "采供信息表")
public class SupplyRelationshipEntity extends TenantFlagOpEntity {
//    @ApiModelProperty(value = "经销商id（EAS）")
//    @Column(name = "source_id", length = 32, columnDefinition = "varchar(32) COMMENT '经销商id（EAS）'")
//    private String sourceId;
//
//    @ApiModelProperty(value = "经销商id（兆信）")
//    @Column(name = "dealer_id", length = 32, columnDefinition = "varchar(32) COMMENT '经销商id（兆信）'")
//    private String dealerId;
//
//    @ApiModelProperty(value = "经销商编码")
//    @Column(name = "dealer_code", length = 32, columnDefinition = "varchar(32) COMMENT '经销商编码'")
//    private String dealerCode;
//
//    @ApiModelProperty(value = "经销商名称")
//    @Column(name = "dealer_name", length = 64, columnDefinition = "varchar(64) COMMENT '经销商名称'")
//    private String dealerName;

    @ApiModelProperty(value = "供货组织id")
    @Column(name = "supplier_org_id", length = 64, columnDefinition = "varchar(64) COMMENT '供货组织id'")
    private String supplierOrgId;

    @ApiModelProperty(value = "供货组织编码")
    @Column(name = "supplier_org_code", length = 32, columnDefinition = "varchar(32) COMMENT '供货组织编码'")
    private String supplierOrgCode;

    @ApiModelProperty(value = "供货组织名称")
    @Column(name = "supplier_org_name", length = 128, columnDefinition = "varchar(128) COMMENT '供货组织名称'")
    private String supplierOrgName;

    @ApiModelProperty(value = "供货单位编码")
    @Column(name = "supplier_code", length = 32, columnDefinition = "varchar(32) COMMENT '供货单位编码'")
    private String supplierCode;

    @ApiModelProperty(value = "供货单位名称")
    @Column(name = "supplier_name", length = 128, columnDefinition = "varchar(128) COMMENT '供货单位名称'")
    private String supplierName;

    @ApiModelProperty(value = "供货单位id（EAS）")
    @Column(name = "supplier_source_id", length = 64, columnDefinition = "varchar(64) COMMENT '供货单位id（EAS）'")
    private String supplierSourceId;

    @ApiModelProperty(value = "供货单位id（兆信）")
    @Column(name = "supplier_id", length = 64, columnDefinition = "varchar(64) COMMENT '供货单位id（兆信）'")
    private String supplierId;

    @ApiModelProperty(value = "供货单位类型")
    @Column(name = "supplier_type", length = 10, columnDefinition = "varchar(10) COMMENT '供货单位类型'")
    private String supplierType;

    @ApiModelProperty(value = "采购单位id（EAS）")
    @Column(name = "buyer_source_id", length = 64, columnDefinition = "varchar(64) COMMENT '采购单位id（EAS）'")
    private String buyerSourceId;

    @ApiModelProperty(value = "采购单位id（兆信）")
    @Column(name = "buyer_id", length = 64, columnDefinition = "varchar(64) COMMENT '采购单位id（兆信）'")
    private String buyerId;

    @ApiModelProperty(value = "采购单位编码")
    @Column(name = "buyer_code", length = 32, columnDefinition = "varchar(32) COMMENT '采购单位编码'")
    private String buyerCode;

    @ApiModelProperty(value = "采购单位名称")
    @Column(name = "buyer_name", length = 128, columnDefinition = "varchar(128) COMMENT '采购单位名称'")
    private String buyerName;

    @ApiModelProperty(value = "采购商类型")
    @Column(name = "buyer_type", length = 10, columnDefinition = "varchar(10) COMMENT '采购商类型'")
    private String buyerType;

    @ApiModelProperty(value = "采购商小类型")
    @Column(name = "buyer_small_type", length = 10, columnDefinition = "varchar(10) COMMENT '采购商小类型'")
    private String buyerSmallType;

    @ApiModelProperty(value = "采购商分类")
    @Column(name = "buyer_classify", length = 10, columnDefinition = "varchar(10) COMMENT '采购商分类'")
    private String buyerClassify;

    @ApiModelProperty(value = "采购商品数量")
    @Column(name = "buy_num", length = 20, columnDefinition = "int(20) COMMENT '采购商品数量'")
    private Integer buyNum;

    @ApiModelProperty(value = "状态")
    @Column(name = "status", length = 10, columnDefinition = "varchar(10) COMMENT '状态'")
    private String status;

}
