package com.biz.crm.mdm.business.customer.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.local.entity.CustomerEntity;
import com.biz.crm.mdm.business.customer.local.model.MultipleConditionModel;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerPageDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerQueryDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerSelectDto;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerPageVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * 客户的mybatis-plus接口类 {@link CustomerEntity}
 *
 * @author ning.zhang
 * @date 2021/9/28
 */
public interface CustomerMapper extends BaseMapper<CustomerEntity> {

  /**
   * 客户信息下拉框分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 客户信息下拉框分页列表
   */
  Page<CustomerEntity> findByCustomerSelectDto(@Param("page") Page<CustomerEntity> page, @Param("dto") CustomerSelectDto dto);


  /**
   * 分页查询
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 查询结果
   */
  Page<CustomerEntity> findByConditions(@Param("page") Page<CustomerEntity> page, @Param("dto") CustomerDto dto);


  /**
   * 通过ID或者编码获取客户信息详情(包含关联数据)
   *
   * @param id           客户ID
   * @param customerCode 客户编码
   * @param tenantCode   租户编码
   * @return 客户信息详情(包含关联数据)
   */
  CustomerEntity findDetailsByIdOrCode(@Param("id") String id, @Param("customerCode") String customerCode, @Param("tenantCode") String tenantCode);

  /**
   * 多条件查询客户列表
   * @param model 条件model
   * @return 客户列表
   */
  List<CustomerEntity> findByMultipleConditionModel(@Param("model") MultipleConditionModel model);


  /**
   * 根据企业组织获取对应的客户信息
   *
   * @param orgCodeList
   * @param delFlag
   * @param tenantCode
   * @return
   */
  List<CustomerEntity> findByOrgCodes(@Param("list") List<String> orgCodeList, @Param("delFlag") String delFlag, @Param("tenantCode") String tenantCode);

  /**
   * 上级客户信息下拉框分页列表
   * @param page
   * @param tenantCode
   * @return
   */
  Page<CustomerEntity> findByParentCustomerIsNull(Page<CustomerEntity> page, @Param("status") String status,@Param("tenantCode") String tenantCode);

  /**
   * 根据标签id查询
   * @param page
   * @param tagId
   * @return
   */
  Page<CustomerEntity> findByTagId(Page<CustomerEntity> page, @Param("tagId") String tagId,@Param("tenantCode") String tenantCode);

  /**
   * 根据组织集合、渠道集合、标签集合查询客户编码集合
   * 参数非必填项所以不需要进行参数校验
   *
   * @param orgCodes 组织集合
   * @param channels 渠道集合
   * @param tags 标签集合
   * @param tenantCode
   * @return 客户编码集合
   */
  Set<String> findCustomerCodesByOrgCodesAndChannelsAndTags(@Param("orgCodes") List<String> orgCodes, @Param("channels") List<String> channels, @Param("tags") List<String> tags, @Param("tenantCode")String tenantCode);

  /**
   * 下级客户信息分页列表
   * @param page
   * @param tenantCode
   * @param customerCode
   * @return
   */
  Page<CustomerEntity> findChildrenByCustomerCode(Page<CustomerEntity> page, @Param("tenantCode") String tenantCode, @Param("customerCode") String customerCode);

  /**
   * 获取经销商编码集合
   *
   * @param dto
   * @param tenantCode
   * @return
   */
  Set<String> findByCustomerQueryDto(
      @Param("dto") CustomerQueryDto dto, @Param("tenantCode") String tenantCode);

  /**
   * 根据 客户编码 、组织包含、组织不包含 查询
   *
   * @param customerCode 客户代码
   * @param orgCodeIn    组织代码
   * @param orgCodeNotIn org代码不
   * @param delFlag         代码
   * @param tenantCode   租户代码
   * @return {@link List}<{@link CustomerEntity}>
   */
  List<CustomerEntity> findByCustomer7OrgIn7OrgNotIn(
      @Param("customerCode") String customerCode,
      @Param("orgCodeIn") List<String> orgCodeIn,
      @Param("orgCodeNotIn") List<String> orgCodeNotIn,
      @Param("delFlag") String delFlag,
      @Param("tenantCode") String tenantCode
  );

    Page<CustomerPageVo> findByCustomerPageDto(Page<CustomerPageVo> pageable,@Param("dto") CustomerPageDto dto);
}
