package com.biz.crm.mdm.business.customer.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.customer.local.entity.CustomerBillEntity;
import com.biz.crm.mdm.business.customer.local.mapper.CustomerBillMapper;
import org.springframework.stereotype.Component;

/**
 * 客户开票信息实表的数据库访问类 {@link CustomerBillEntity}
 *
 * @author ning.zhang
 * @date 2021-10-26 16:18:13
 */
@Component
public class CustomerBillRepository extends ServiceImpl<CustomerBillMapper, CustomerBillEntity> {

  /**
   * 通过客户编码删除客户开票信息
   *
   * @param customerCode 客户编码
   * @param tenantCode   租户编码
   */
  public void deleteByCustomerCode(String customerCode, String tenantCode) {
    this.lambdaUpdate()
        .eq(CustomerBillEntity::getTenantCode, tenantCode)
        .eq(CustomerBillEntity::getCustomerCode, customerCode)
        .remove();
  }
}
