package com.biz.crm.mdm.business.customer.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.customer.local.entity.CustomerMediaEntity;
import com.biz.crm.mdm.business.customer.local.mapper.CustomerMediaMapper;
import org.springframework.stereotype.Component;

/**
 * 客户媒体文件表的数据库访问类 {@link CustomerMediaEntity}
 *
 * @author ning.zhang
 * @date 2021-10-26 16:26:36
 */
@Component
public class CustomerMediaRepository extends ServiceImpl<CustomerMediaMapper, CustomerMediaEntity> {

  /**
   * 通过客户编码删除客户媒体文件信息
   *
   * @param customerCode 客户编码
   * @param tenantCode   租户编码
   */
  public void deleteByCustomerCode(String customerCode, String tenantCode) {
    this.lambdaUpdate()
        .eq(CustomerMediaEntity::getTenantCode, tenantCode)
        .eq(CustomerMediaEntity::getCustomerCode, customerCode)
        .remove();
  }
}
