package com.biz.crm.mdm.business.customer.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.customer.local.entity.CustomerTagRuleEntity;
import com.biz.crm.mdm.business.customer.local.mapper.CustomerTagRuleMapper;
import org.springframework.stereotype.Component;

import java.util.Collection;

/**
 * 经销商标签规则持久化实现
 * @Author: zengxingwang
 * @Date: 2021/12/21 16:01
 */
@Component
public class CustomerTagRuleRepository extends ServiceImpl<CustomerTagRuleMapper, CustomerTagRuleEntity> {
  /**
   * 重构修改方法
   *
   * @param customerTagRuleEntities
   * @param tenantCode
   */
  public void updateBatchByIdAndTenantCode(Collection<CustomerTagRuleEntity> customerTagRuleEntities, String tenantCode) {

    customerTagRuleEntities.stream().forEach(customerTagRuleEntity -> {
      this.lambdaUpdate()
          .eq(CustomerTagRuleEntity::getTenantCode,tenantCode)
          .in(CustomerTagRuleEntity::getId,customerTagRuleEntity.getId())
          .setEntity(customerTagRuleEntity)
          .update();
    });
  }
}
