package com.biz.crm.mdm.business.customer.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.local.mapper.CustomerTagVoMapper;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerTagDto;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerTagVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 经销商标签持久化
 * @Author: zengxingwang
 * @Date: 2021/12/21 19:36
 */
@Component
public class CustomerTagVoRepository {

  @Autowired(required = false)
  private CustomerTagVoMapper customerTagVoMapper;

  /**
   * 多条件分页查询
   * @param pageable
   * @param customerTagDto
   * @return
   */
  public Page<CustomerTagVo> findByConditions(Pageable pageable, CustomerTagDto customerTagDto) {
    Page<CustomerTagVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return customerTagVoMapper.findByConditions(page, customerTagDto);
  }

  /**
   * 通过客户编码集合获取对接人列表
   *
   * @param customerCodes 客户编码集合
   * @return 对接人列表
   */
  public List<CustomerTagVo> findByCustomerCodes(List<String> customerCodes) {
    return this.customerTagVoMapper.findByCustomerCodes(customerCodes, TenantUtils.getTenantCode());
  }
}
