package com.biz.crm.mdm.business.customer.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.customer.local.entity.DealerOrgRelationshipEntity;
import com.biz.crm.mdm.business.customer.local.mapper.DealerOrgRelationshipMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName DealerOrgRelationshipRepostory
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/16 18:05
 **/
@Component
public class DealerOrgRelationshipRepository extends ServiceImpl<DealerOrgRelationshipMapper, DealerOrgRelationshipEntity> {


    public List<DealerOrgRelationshipEntity> listByDealerCodes(List<String> dealerCodes){
        if (CollectionUtils.isEmpty(dealerCodes)){
            return Lists.newArrayList();
        }
        List<DealerOrgRelationshipEntity> list = this.lambdaQuery()
                .eq(DealerOrgRelationshipEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(DealerOrgRelationshipEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .in(DealerOrgRelationshipEntity::getDealerCode, dealerCodes)
                .list();
        if (CollectionUtils.isEmpty(list)){
            Lists.newArrayList();
        }
        return list;
    }

    public List<DealerOrgRelationshipEntity> listByDealerIds(List<String> dealerIds){
        if (CollectionUtils.isEmpty(dealerIds)){
            return Lists.newArrayList();
        }
        List<DealerOrgRelationshipEntity> list = this.lambdaQuery()
                .eq(DealerOrgRelationshipEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(DealerOrgRelationshipEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .in(DealerOrgRelationshipEntity::getDealerId, dealerIds)
                .list();
        if (CollectionUtils.isEmpty(list)){
            Lists.newArrayList();
        }
        return list;
    }

}
