package com.biz.crm.mdm.business.customer.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.customer.local.entity.CustomerSaleAreaEntity;
import com.biz.crm.mdm.business.customer.local.entity.DealerSalesRegionEntity;
import com.biz.crm.mdm.business.customer.local.mapper.DealerSalesRegionMapper;
import com.biz.crm.mdm.business.customer.sdk.vo.DealerSalesRegionVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName DealerSalesRegionRepository
 * @Description 经销商销售区域
 * @AUTHOR WangJJ
 * @DATE 2023/7/12 15:22
 **/
@Component
public class DealerSalesRegionRepository extends ServiceImpl<DealerSalesRegionMapper, DealerSalesRegionEntity> {

    public List<DealerSalesRegionEntity> findByDealerId(String dealerId){
        if (StringUtils.isEmpty(dealerId)){
            return Lists.newArrayList();
        }
        List<DealerSalesRegionEntity> list = this.lambdaQuery()
                .eq(DealerSalesRegionEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(DealerSalesRegionEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(DealerSalesRegionEntity::getDealerId, dealerId)
                .list();
        if (CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        return list;
    }


    public List<DealerSalesRegionEntity> findByDealerIds(List<String> dealerIds) {
        if (CollectionUtils.isEmpty(dealerIds)){
            return Lists.newArrayList();
        }
        List<DealerSalesRegionEntity> list = this.lambdaQuery()
                .eq(DealerSalesRegionEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(DealerSalesRegionEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(DealerSalesRegionEntity::getDealerId, dealerIds)
                .list();
        if (CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        return list;
    }

}
