package com.biz.crm.mdm.business.customer.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.customer.local.entity.SupplyRelationshipDetailEntity;
import com.biz.crm.mdm.business.customer.local.mapper.SupplyRelationshipDetailMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @ClassName DealerSupplyRelationshipDetailRepository
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/14 9:22
 **/
@Component
public class SupplyRelationshipDetailRepository extends ServiceImpl<SupplyRelationshipDetailMapper, SupplyRelationshipDetailEntity> {

    public List<SupplyRelationshipDetailEntity> findBySupplyRelationshipIds(List<String> ids){
        if (CollectionUtils.isEmpty(ids)){
            return Lists.newArrayList();
        }
        List<SupplyRelationshipDetailEntity> list = this.lambdaQuery()
                .eq(SupplyRelationshipDetailEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(SupplyRelationshipDetailEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(SupplyRelationshipDetailEntity::getSupplyRelationshipId, ids)
                .list();
        if (CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        return list;
    }

    public void removeBySupplyRelationshipIds(List<String> ids){
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        this.lambdaUpdate()
                .in(SupplyRelationshipDetailEntity::getSupplyRelationshipId, ids)
                .remove();
    }


}
