package com.biz.crm.mdm.business.customer.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.customer.local.entity.SupplyRelationshipEntity;
import com.biz.crm.mdm.business.customer.local.mapper.SupplyRelationshipMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName DealerSupplyRelationshipRepository
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/13 17:56
 **/
@Component
public class SupplyRelationshipRepository extends ServiceImpl<SupplyRelationshipMapper, SupplyRelationshipEntity> {

    public SupplyRelationshipEntity findById(String id){
        if (StringUtils.isEmpty(id)){
            return null;
        }
        return this.lambdaQuery()
                .eq(SupplyRelationshipEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(SupplyRelationshipEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(SupplyRelationshipEntity::getId, id)
                .one();
    }

    public List<SupplyRelationshipEntity> findByBuyerId(String buyerId){
        if (StringUtils.isEmpty(buyerId)){
            return null;
        }
        return this.lambdaQuery()
                .eq(SupplyRelationshipEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(SupplyRelationshipEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(SupplyRelationshipEntity::getBuyerId, buyerId)
                .list();
    }

    public List<SupplyRelationshipEntity> findByBuyerIds(List<String> buyerIds){
        if (CollectionUtils.isEmpty(buyerIds)){
            return Lists.newArrayList();
        }
        List<SupplyRelationshipEntity> list = this.lambdaQuery()
                .eq(SupplyRelationshipEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(SupplyRelationshipEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(SupplyRelationshipEntity::getBuyerId, buyerIds)
                .list();
        if (CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        return list;
    }

    public void removeByBuyerId(String buyerId){
        if (StringUtils.isEmpty(buyerId)){
            return;
        }
        this.lambdaUpdate()
                .eq(SupplyRelationshipEntity::getBuyerId, buyerId)
                .remove();
    }

}
