package com.biz.crm.mdm.business.customer.local.service;

import com.biz.crm.mdm.business.customer.sdk.dto.CustomerDockingSupplyDto;

import java.util.List;

/**
 * 客户对接人供货信息表服务接口
 *
 * @author ning.zhang
 * @date 2021-10-26 16:25:42
 */
public interface CustomerDockingSupplyService {

  /**
   * 通过对接人ID集合删除对接人供货信息
   *
   * @param dockingIds 对接人ID集合
   */
  void deleteByDockingIds(List<String> dockingIds);

  /**
   * 客户对接人供货关系信息绑定对接人ID
   *
   * @param dtoList   客户对接人供货关系信息
   * @param dockingId 对接人ID
   */
  void bindDockingId(List<CustomerDockingSupplyDto> dtoList, String dockingId);
}
