package com.biz.crm.mdm.business.customer.local.service;

import com.biz.crm.mdm.business.customer.local.entity.CustomerROrgEntity;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerDto;
import com.biz.crm.mdm.business.customer.sdk.vo.DealerOrgRelationshipVo;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 客户与企业组织关联表服务接口
 *
 * @author ning.zhang
 * @date 2021-11-10 10:19:10
 */
public interface CustomerROrgService {

  /**
   * 客户与企业组织关系重绑绑定客户编码
   *
   * @param dto      企业组织编码(多个逗号分隔)
   */
  void rebindCustomerCode(CustomerDto dto);

  /**
   * 重新绑定企业组织编码
   *
   * @param orgCode          企业组织编码
   * @param originOrgCode    原企业组织编码
   * @param customerCodeList 客户编码集合
   */
  void rebindOrgCode(String orgCode, String originOrgCode, List<String> customerCodeList);

  /**
   * 根据客户编码获取组织信息
   *
   * @param customerCodes
   * @return
   */
  List<CustomerROrgEntity> findByCustomerCodes(Set<String> customerCodes);

  /**
   * 根据组织编码获取组织信息
   *
   * @param orgCodes
   * @return
   */
  List<CustomerROrgEntity> findAllowSaleCustomerByOrgCodes(Set<String> orgCodes);


  /**
   * 根据经销商编码集合获取经销商组织Map信息
   * @param dealerIds 经销商ID(兆信)集合
   * @return Map<String,List<DealerOrgRelationshipVo>  Map<经销商ID(兆信),关联组织关系集合>
   */
  Map<String,List<CustomerROrgEntity>> findDealerOrgRelationshipMap(List<String> dealerIds);

}
