package com.biz.crm.mdm.business.customer.local.service;

import com.biz.crm.mdm.business.customer.local.entity.CustomerTagEntity;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerTagDto;

import java.util.List;

/**
 * 客户标签表服务接口
 *
 * @author ning.zhang
 * @date 2021-10-26 16:27:42
 */
public interface CustomerTagService {

  /**
   * 通过客户编码查询客户标签列表
   *
   * @param customerCode 客户编码
   * @return 客户标签列表
   */
  List<CustomerTagEntity> findByCustomerCode(String customerCode);

  /**
   * 通过客户编码查询客户标签列表
   *
   * @param customerCodes 客户编码
   * @return 客户标签列表
   */
  List<CustomerTagEntity> findByCustomerCodes(List<String> customerCodes);

  /**
   * 创建客户标签
   *
   * @param dto 参数dto
   * @return 创建的客户标签
   */
  CustomerTagEntity create(CustomerTagDto dto);

  /**
   * 批量删除客户标签
   *
   * @param ids 客户标签id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 更新客户标签
   * @param dto
   * @return
   */
  CustomerTagEntity update(CustomerTagDto dto);

  /**
   * 批量启用
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 查看详情（包括关联信息）
   * @param id
   * @return
   */
  CustomerTagEntity findDetailById(String id);

  /**
   * 调用经销商标签定时任务
   */
  void handleCustomerTagTask();
}
