package com.biz.crm.mdm.business.customer.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.local.entity.CustomerGroupDetailEntity;
import com.biz.crm.mdm.business.customer.local.entity.CustomerGroupEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerGroupDetailRepository;
import com.biz.crm.mdm.business.customer.local.repository.CustomerGroupRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerGroupService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerGroupDetailVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerGroupVo;
import com.biz.crm.mdm.business.position.sdk.deprecated.dto.MdmPositionUserOrgPageDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 客户组实现类
 *
 * @author lgq
 * @date 2023/6/13 16:48
 */
@Service
public class CustomerGroupServiceImpl implements CustomerGroupService {

  @Autowired
  private CustomerGroupRepository customerGroupRepository;

  @Autowired
  private CustomerGroupDetailRepository detailRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void create(CustomerGroupVo customerGroupVo) {
    validateForm(customerGroupVo);
    String customerGroupsCode = customerGroupVo.getCustomerGroupsCode();
    CustomerGroupEntity customerGroupEntity = nebulaToolkitService.copyObjectByWhiteList(customerGroupVo, CustomerGroupEntity.class, HashSet.class, ArrayList.class);
    customerGroupEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    customerGroupEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    customerGroupEntity.setTenantCode(TenantUtils.getTenantCode());
    List<CustomerGroupDetailVo> itemList = customerGroupVo.getItemList();
    customerGroupEntity.setDealerNum(String.valueOf(itemList.size()));
    List<CustomerGroupDetailEntity> itemEntityList = (List<CustomerGroupDetailEntity>) this.nebulaToolkitService.copyCollectionByBlankList(itemList, CustomerGroupDetailVo.class, CustomerGroupDetailEntity.class, HashSet.class, ArrayList.class);
    itemEntityList.forEach(o->{
      o.setCustomerGroupsCode(customerGroupsCode);
    });
    this.customerGroupRepository.save(customerGroupEntity);
    this.detailRepository.lambdaUpdate().eq(CustomerGroupDetailEntity::getCustomerGroupsCode,customerGroupsCode).remove();
    this.detailRepository.saveBatch(itemEntityList);
  }


  @Override
  @Transactional(rollbackFor = Exception.class)
  public void modify(CustomerGroupVo customerGroupVo) {
    Validate.notEmpty(customerGroupVo.getId(), "标识不能为空");
    validateForm(customerGroupVo);
    String customerGroupsCode = customerGroupVo.getCustomerGroupsCode();
    CustomerGroupEntity customerGroupEntity = nebulaToolkitService.copyObjectByWhiteList(customerGroupVo, CustomerGroupEntity.class, HashSet.class, ArrayList.class);
    customerGroupEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    customerGroupEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    customerGroupEntity.setTenantCode(TenantUtils.getTenantCode());
    List<CustomerGroupDetailVo> itemList = customerGroupVo.getItemList();
    customerGroupEntity.setDealerNum(String.valueOf(itemList.size()));
    List<CustomerGroupDetailEntity> itemEntityList = (List<CustomerGroupDetailEntity>) this.nebulaToolkitService.copyCollectionByBlankList(itemList, CustomerGroupDetailVo.class, CustomerGroupDetailEntity.class, HashSet.class, ArrayList.class);
    itemEntityList.forEach(o->{
      o.setCustomerGroupsCode(customerGroupsCode);
    });
    this.customerGroupRepository.save(customerGroupEntity);
    this.detailRepository.lambdaUpdate().eq(CustomerGroupDetailEntity::getCustomerGroupsCode,customerGroupsCode).remove();
    this.detailRepository.updateBatchById(itemEntityList);
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void delete(List<String> idList) {
    this.customerGroupRepository.lambdaUpdate().in(CustomerGroupEntity::getId,idList).set(CustomerGroupEntity::getDelFlag,DelFlagStatusEnum.DELETE.getCode()).update();
  }

  @Override
  public CustomerGroupVo detail(String id) {
    CustomerGroupEntity entity = this.customerGroupRepository.getById(id);
    CustomerGroupVo customerGroupVo = nebulaToolkitService.copyObjectByWhiteList(entity, CustomerGroupVo.class, HashSet.class, ArrayList.class);
    List<CustomerGroupDetailEntity> detailList = this.detailRepository.lambdaQuery().eq(CustomerGroupDetailEntity::getCustomerGroupsCode, customerGroupVo.getCustomerGroupsCode()).list();
    if(CollectionUtils.isNotEmpty(detailList)){
      List<CustomerGroupDetailVo> customerGroupDetailVoList = (List<CustomerGroupDetailVo>) this.nebulaToolkitService.copyCollectionByBlankList(detailList, CustomerGroupDetailEntity.class, CustomerGroupDetailVo.class, HashSet.class, ArrayList.class);
      customerGroupVo.setItemList(customerGroupDetailVoList);
    }
    return customerGroupVo;
  }

  private void validateForm(CustomerGroupVo o) {
    Validate.notEmpty(o.getCustomerGroupsCode(), "客户组编码不能为空");
    Validate.notEmpty(o.getCustomerGroupsName(), "客户组名称不能为空");
    Validate.notEmpty(o.getClassifyStandard(), "分类标准不能为空");
    List<CustomerGroupDetailVo> itemList = o.getItemList();
    Validate.notEmpty(o.getClassifyStandard(), "经销商明细不能为空");
    itemList.forEach(e -> {
      Validate.notEmpty(e.getDealerCode(), "经销商编码不能为空");
      Validate.notEmpty(e.getDealerName(), "经销商名称不能为空");
    });
  }

}
