package com.biz.crm.mdm.business.customer.local.service.internal;

import com.biz.crm.mdm.business.customer.local.entity.CustomerMediaEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerMediaRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerMediaService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerUploadDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 客户媒体文件表服务实现类
 *
 * @author ning.zhang
 * @date 2021-10-26 16:26:37
 */
@Service("customerMediaService")
public class CustomerMediaServiceImpl implements CustomerMediaService {

  @Autowired(required = false)
  private CustomerMediaRepository customerMediaRepository;

  @Override
  @Transactional
  public void rebindCustomerCode(List<CustomerUploadDto> dtoList, String customerCode) {
    Validate.notBlank(customerCode, "客户编码不能为空");
    String tenantCode = TenantUtils.getTenantCode();
    this.customerMediaRepository.deleteByCustomerCode(customerCode, tenantCode);
    if (CollectionUtils.isEmpty(dtoList)) {
      return;
    }
    List<CustomerMediaEntity> entities = dtoList.stream()
        .filter(dto -> Objects.nonNull(dto) && StringUtils.isNotEmpty(dto.getFileCode()) && Objects.nonNull(dto.getFileType()))
        .map(dto -> {
          CustomerMediaEntity entity = new CustomerMediaEntity();
          entity.setOriginalFileName(dto.getOriginalFileName());
          entity.setCustomerCode(customerCode);
          entity.setFileCode(dto.getFileCode());
          entity.setFileType(dto.getFileType());
          entity.setTenantCode(tenantCode);
          return entity;
        }).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(entities)) {
      return;
    }
    this.customerMediaRepository.saveBatch(entities);
  }
}
