package com.biz.crm.mdm.business.customer.local.service.internal;

import com.biz.crm.mdm.business.customer.local.entity.DealerOrgRelationshipEntity;
import com.biz.crm.mdm.business.customer.local.repository.DealerOrgRelationshipRepository;
import com.biz.crm.mdm.business.customer.sdk.service.DealerOrgRelationshipService;
import com.biz.crm.mdm.business.customer.sdk.vo.DealerOrgRelationshipVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @ClassName DealerOrgRelationshipServiceImpl
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/19 10:02
 **/
@Service
@Slf4j
public class DealerOrgRelationshipServiceImpl implements DealerOrgRelationshipService {

    @Autowired(required = false)
    private DealerOrgRelationshipRepository dealerOrgRelationshipRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;


    @Override
    public List<DealerOrgRelationshipVo> listByDealerCodes(List<String> dealerCodes) {
        if (CollectionUtils.isEmpty(dealerCodes)){
            return Lists.newArrayList();
        }

        List<DealerOrgRelationshipEntity> entities = this.dealerOrgRelationshipRepository.listByDealerCodes(dealerCodes);
        List<DealerOrgRelationshipVo> vos = (ArrayList<DealerOrgRelationshipVo>)this.nebulaToolkitService.copyCollectionByBlankList(entities, DealerOrgRelationshipEntity.class, DealerOrgRelationshipVo.class, HashSet.class, ArrayList.class);
        return vos;
    }

    @Override
    public Map<String, List<DealerOrgRelationshipVo>> findDealerOrgRelationshipMap(List<String> dealerIds) {
        if (CollectionUtils.isEmpty(dealerIds)){
            return Maps.newHashMap();
        }
        List<DealerOrgRelationshipEntity> entities = this.dealerOrgRelationshipRepository.listByDealerIds(dealerIds);
        List<DealerOrgRelationshipVo> vos = (ArrayList<DealerOrgRelationshipVo>)this.nebulaToolkitService.copyCollectionByBlankList(entities, DealerOrgRelationshipEntity.class, DealerOrgRelationshipVo.class, HashSet.class, ArrayList.class);
        Map<String, List<DealerOrgRelationshipVo>> listMap = vos.stream().collect(Collectors.groupingBy(DealerOrgRelationshipVo::getDealerId));
        return listMap;
    }
}
