package com.biz.crm.mdm.business.customer.local.service.notifier;

import com.biz.crm.mdm.business.customer.local.entity.CustomerEntity;
import com.biz.crm.mdm.business.customer.local.model.MultipleConditionModel;
import com.biz.crm.mdm.business.customer.local.service.CustomerService;
import com.biz.crm.mdm.business.position.sdk.event.PositionEventListener;
import com.biz.crm.mdm.business.position.sdk.vo.PositionEventVo;
import com.biz.crm.mdm.business.position.sdk.vo.PositionRelationVo;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 客户职位信息变更事件通知接口实现
 *
 * @author ning.zhang
 * @date 2021/10/28
 */
@Component
public class CusPositionEventListener implements PositionEventListener {

  @Autowired(required = false)
  private CustomerService customerService;

  @Override
  public void onCreate(PositionEventVo vo) {
    // do nothing
  }

  @Override
  public void onUpdate(PositionEventVo oldVo, PositionEventVo newVo) {
    // do nothing
  }

  @Override
  public void onDisable(List<PositionEventVo> voList) {
    // do nothing
  }

  @Override
  public void onEnable(List<PositionEventVo> voList) {
    // do nothing
  }

  /**
   * 当职位发生删除事件时，根据触发事件的职位信息的职位编码,验证职位是否存在与客户对接人的关联关系。
   * <p>
   * 1.存在与客户对接人的关联关系,则抛出职位已关联客户对接人的异常,阻断当前职位的删除操作
   * 2.不存在与客户对接人的关联关系,则什么也不做.
   */
  @Override
  public void onDelete(List<PositionEventVo> voList) {
    if (CollectionUtils.isEmpty(voList)) {
      return;
    }
    List<String> positionCodes = voList.stream().map(PositionEventVo::getPositionCode)
        .filter(Objects::nonNull).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(positionCodes)) {
      return;
    }
    MultipleConditionModel model = new MultipleConditionModel();
    model.setDockingPositionCodes(positionCodes);
    List<CustomerEntity> list = customerService.findByMultipleConditionModel(model);
    Validate.isTrue(CollectionUtils.isEmpty(list), "存在与客户对接人的绑定关系不能删除");
  }

  @Override
  public List<PositionRelationVo> onRequestByPositionCodes(List<String> positionCodes) {
    return Lists.newArrayList();
  }
}
