/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.local.entity.CustomerTagEntity;
import com.biz.crm.mdm.business.customer.local.service.CustomerTagService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerTagDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5ba2\u6237\u4fe1\u606f: customerTag: \u5ba2\u6237\u6807\u7b7e\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/customerTag/customerTag"})
public class CustomerTagController {
    private static final Logger log = LoggerFactory.getLogger(CustomerTagController.class);
    @Autowired(required=false)
    private CustomerTagService customerTagService;

    @ApiOperation(value="\u65b0\u589e\u5ba2\u6237\u6807\u7b7e")
    @PostMapping(value={"/create"})
    public Result<CustomerTagEntity> create(@RequestBody CustomerTagDto dto) {
        try {
            return Result.ok((Object)((Object)this.customerTagService.create(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u5ba2\u6237\u6807\u7b7e")
    @PatchMapping(value={""})
    public Result<CustomerTagEntity> update(@RequestBody CustomerTagDto dto) {
        try {
            return Result.ok((Object)((Object)this.customerTagService.update(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            this.customerTagService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u542f\u7528")
    @PatchMapping(value={"/enableBatch"})
    public Result<?> enableBatch(@RequestBody List<String> ids) {
        try {
            this.customerTagService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u7981\u7528")
    @PatchMapping(value={"/disableBatch"})
    public Result<?> disableBatch(@RequestBody List<String> ids) {
        try {
            this.customerTagService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u770b\u8be6\u60c5\uff08\u5305\u62ec\u5173\u8054\u4fe1\u606f\uff09")
    @GetMapping(value={"/findDetailById"})
    public Result<CustomerTagEntity> findDetailById(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        try {
            return Result.ok((Object)((Object)this.customerTagService.findDetailById(id)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u5ba2\u6237\u7f16\u7801\u67e5\u8be2\u5ba2\u6237\u6807\u7b7e\u5217\u8868")
    @GetMapping(value={"/findByCustomerCode"})
    public Result<?> findByCustomerCode(@RequestParam(value="customerCode") @ApiParam(name="customerCode", value="\u5ba2\u6237\u7f16\u7801") String customerCode) {
        try {
            return Result.ok(this.customerTagService.findByCustomerCode(customerCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8c03\u7528\u7ecf\u9500\u5546\u6807\u7b7e\u5b9a\u65f6\u4efb\u52a1")
    @GetMapping(value={"/handleCustomerTagTask"})
    public Result<?> handleCustomerTagTask() {
        try {
            this.customerTagService.handleCustomerTagTask();
            return Result.ok((String)"\u6267\u884c\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

