/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.mdm.business.customer.local.entity.CustomerDockingEntity;
import com.biz.crm.mdm.business.customer.local.mapper.CustomerDockingMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CustomerDockingRepository
extends ServiceImpl<CustomerDockingMapper, CustomerDockingEntity> {
    public List<CustomerDockingEntity> findByCustomerCode(String customerCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(CustomerDockingEntity::getCustomerCode, (Object)customerCode)).list();
    }

    public List<CustomerDockingEntity> findByCustomerCodesAndPositionCode(List<String> customerCodes, String positionCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(CustomerDockingEntity::getCustomerCode, customerCodes)).eq(CustomerDockingEntity::getPositionCode, (Object)positionCode)).list();
    }

    public List<CustomerDockingEntity> findByCustomerCodes(List<String> customerCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(CustomerDockingEntity::getCustomerCode, customerCodes)).list();
    }

    public void deleteByIdsAndTenantCode(List<String> dockingIds, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, dockingIds)).remove();
    }

    public void removeByIdsAndTenantCode(List<String> dockingIds, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, dockingIds)).remove();
    }
}

