/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.customer.local.entity.CustomerROrgEntity;
import com.biz.crm.mdm.business.customer.local.mapper.CustomerROrgMapper;
import com.biz.crm.mdm.business.customer.sdk.enums.ExternalStatusEnum;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class CustomerROrgRepository
extends ServiceImpl<CustomerROrgMapper, CustomerROrgEntity> {
    private static final Integer SIZE = 1000;

    public void deleteByCustomerCode(String customerCode, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(CustomerROrgEntity::getCustomerCode, (Object)customerCode)).remove();
    }

    public void rebindOrgCode(String orgCode, String originOrgCode, List<String> customerCodeList, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(CustomerROrgEntity::getOrgCode, (Object)originOrgCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(CustomerROrgEntity::getCustomerCode, customerCodeList)).set(CustomerROrgEntity::getOrgCode, (Object)orgCode)).update();
    }

    public List<CustomerROrgEntity> findByCustomerCodes(List<String> customerCodeList, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(CustomerROrgEntity::getCustomerCode, customerCodeList)).list();
    }

    public List<CustomerROrgEntity> findAllowSaleCustomerByOrgCodes(Set<String> orgCodes) {
        ArrayList list = Lists.newArrayList();
        String processStatus = ProcessStatusEnum.PASS.getDictCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        String tenantCode = TenantUtils.getTenantCode();
        for (List item : Lists.partition((List)Lists.newArrayList(orgCodes), (int)SIZE)) {
            List<CustomerROrgEntity> cur = ((CustomerROrgMapper)this.baseMapper).findAllowSaleCustomerByOrgCodes(item, processStatus, delFlag, tenantCode);
            if (CollectionUtils.isEmpty(cur)) continue;
            list.addAll(cur);
        }
        return list;
    }

    public List<CustomerROrgEntity> listByDealerIds(List<String> dealerIds) {
        if (CollectionUtils.isEmpty(dealerIds)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(CustomerROrgEntity::getStatus, (Object)ExternalStatusEnum.ENABLE.getExternalCode())).in(CustomerROrgEntity::getDealerId, dealerIds)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            Lists.newArrayList();
        }
        return list;
    }
}

