/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.customer.local.entity.SupplyRelationshipEntity;
import com.biz.crm.mdm.business.customer.local.mapper.SupplyRelationshipMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SupplyRelationshipRepository
extends ServiceImpl<SupplyRelationshipMapper, SupplyRelationshipEntity> {
    public SupplyRelationshipEntity findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        return (SupplyRelationshipEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidEntity::getId, (Object)id)).one());
    }

    public List<SupplyRelationshipEntity> findByBuyerId(String buyerId) {
        if (StringUtils.isEmpty((CharSequence)buyerId)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(SupplyRelationshipEntity::getBuyerId, (Object)buyerId)).list();
    }

    public List<SupplyRelationshipEntity> findByBuyerIds(List<String> buyerIds) {
        if (CollectionUtils.isEmpty(buyerIds)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(SupplyRelationshipEntity::getBuyerId, buyerIds)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public void removeByBuyerId(String buyerId) {
        if (StringUtils.isEmpty((CharSequence)buyerId)) {
            return;
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(SupplyRelationshipEntity::getBuyerId, (Object)buyerId)).remove();
    }
}

