/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.internal;

import com.biz.crm.mdm.business.customer.local.entity.CustomerDockingSupplyEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerDockingSupplyRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerDockingSupplyService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerDockingSupplyDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerDockingSupplyService")
public class CustomerDockingSupplyServiceImpl
implements CustomerDockingSupplyService {
    @Autowired(required=false)
    private CustomerDockingSupplyRepository customerDockingSupplyRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void deleteByDockingIds(List<String> dockingIds) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(dockingIds), (String)"\u5bf9\u63a5\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.customerDockingSupplyRepository.deleteByDockingIds(dockingIds);
    }

    @Override
    @Transactional
    public void bindDockingId(List<CustomerDockingSupplyDto> dtoList, String dockingId) {
        Validate.notBlank((CharSequence)dockingId, (String)"\u5bf9\u63a5\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        List entities = dtoList.stream().filter(dto -> Objects.nonNull(dto) && StringUtils.isNotBlank((CharSequence)dto.getCode())).map(dto -> {
            CustomerDockingSupplyEntity entity = (CustomerDockingSupplyEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, CustomerDockingSupplyEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setDockingId(dockingId);
            entity.setTenantCode(tenantCode);
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.customerDockingSupplyRepository.saveBatch(entities);
    }
}

