/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.local.entity.CustomerGroupDetailEntity;
import com.biz.crm.mdm.business.customer.local.entity.CustomerGroupEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerGroupDetailRepository;
import com.biz.crm.mdm.business.customer.local.repository.CustomerGroupRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerGroupService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerGroupDetailVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerGroupVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerGroupServiceImpl
implements CustomerGroupService {
    @Autowired
    private CustomerGroupRepository customerGroupRepository;
    @Autowired
    private CustomerGroupDetailRepository detailRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void create(CustomerGroupVo customerGroupVo) {
        this.validateForm(customerGroupVo);
        String customerGroupsCode = customerGroupVo.getCustomerGroupsCode();
        CustomerGroupEntity customerGroupEntity = (CustomerGroupEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerGroupVo, CustomerGroupEntity.class, HashSet.class, ArrayList.class, new String[0]));
        customerGroupEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        customerGroupEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        customerGroupEntity.setTenantCode(TenantUtils.getTenantCode());
        List itemList = customerGroupVo.getItemList();
        customerGroupEntity.setDealerNum(String.valueOf(itemList.size()));
        List itemEntityList = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)itemList, CustomerGroupDetailVo.class, CustomerGroupDetailEntity.class, HashSet.class, ArrayList.class, new String[0]);
        itemEntityList.forEach(o -> o.setCustomerGroupsCode(customerGroupsCode));
        this.customerGroupRepository.save((Object)customerGroupEntity);
        ((LambdaUpdateChainWrapper)this.detailRepository.lambdaUpdate().eq(CustomerGroupDetailEntity::getCustomerGroupsCode, (Object)customerGroupsCode)).remove();
        this.detailRepository.saveBatch(itemEntityList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modify(CustomerGroupVo customerGroupVo) {
        Validate.notEmpty((CharSequence)customerGroupVo.getId(), (String)"\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validateForm(customerGroupVo);
        String customerGroupsCode = customerGroupVo.getCustomerGroupsCode();
        CustomerGroupEntity customerGroupEntity = (CustomerGroupEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerGroupVo, CustomerGroupEntity.class, HashSet.class, ArrayList.class, new String[0]));
        customerGroupEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        customerGroupEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        customerGroupEntity.setTenantCode(TenantUtils.getTenantCode());
        List itemList = customerGroupVo.getItemList();
        customerGroupEntity.setDealerNum(String.valueOf(itemList.size()));
        List itemEntityList = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)itemList, CustomerGroupDetailVo.class, CustomerGroupDetailEntity.class, HashSet.class, ArrayList.class, new String[0]);
        itemEntityList.forEach(o -> o.setCustomerGroupsCode(customerGroupsCode));
        this.customerGroupRepository.save((Object)customerGroupEntity);
        ((LambdaUpdateChainWrapper)this.detailRepository.lambdaUpdate().eq(CustomerGroupDetailEntity::getCustomerGroupsCode, (Object)customerGroupsCode)).remove();
        this.detailRepository.updateBatchById(itemEntityList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.customerGroupRepository.lambdaUpdate().in(UuidEntity::getId, idList)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    @Override
    public CustomerGroupVo detail(String id) {
        CustomerGroupEntity entity = (CustomerGroupEntity)((Object)this.customerGroupRepository.getById((Serializable)((Object)id)));
        CustomerGroupVo customerGroupVo = (CustomerGroupVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, CustomerGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
        List detailList = ((LambdaQueryChainWrapper)this.detailRepository.lambdaQuery().eq(CustomerGroupDetailEntity::getCustomerGroupsCode, (Object)customerGroupVo.getCustomerGroupsCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            List customerGroupDetailVoList = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)detailList, CustomerGroupDetailEntity.class, CustomerGroupDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
            customerGroupVo.setItemList(customerGroupDetailVoList);
        }
        return customerGroupVo;
    }

    private void validateForm(CustomerGroupVo o) {
        Validate.notEmpty((CharSequence)o.getCustomerGroupsCode(), (String)"\u5ba2\u6237\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)o.getCustomerGroupsName(), (String)"\u5ba2\u6237\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)o.getClassifyStandard(), (String)"\u5206\u7c7b\u6807\u51c6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List itemList = o.getItemList();
        Validate.notEmpty((CharSequence)o.getClassifyStandard(), (String)"\u7ecf\u9500\u5546\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        itemList.forEach(e -> {
            Validate.notEmpty((CharSequence)e.getDealerCode(), (String)"\u7ecf\u9500\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)e.getDealerName(), (String)"\u7ecf\u9500\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        });
    }
}

