/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.mdm.business.customer.local.entity.CustomerSaleAreaEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerSaleAreaRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerSaleAreaService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerSaleAreaDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerSaleAreaService")
public class CustomerSaleAreaServiceImpl
implements CustomerSaleAreaService {
    @Autowired(required=false)
    private CustomerSaleAreaRepository customerSaleAreaRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void rebindCustomerCode(List<CustomerSaleAreaDto> dtoList, String customerCode) {
        Validate.notBlank((CharSequence)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        this.customerSaleAreaRepository.deleteByCustomerCode(customerCode, tenantCode);
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List entities = dtoList.stream().filter(dto -> Objects.nonNull(dto) && StringUtils.isNotEmpty((CharSequence)dto.getAreaOne())).map(dto -> {
            CustomerSaleAreaEntity entity = (CustomerSaleAreaEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, CustomerSaleAreaEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setCustomerCode(customerCode);
            entity.setTenantCode(tenantCode);
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.customerSaleAreaRepository.saveBatch(entities);
    }

    @Override
    public List<CustomerSaleAreaEntity> findByCustomerCode(List<String> code) {
        if (CollectionUtils.isEmpty(code)) {
            return Lists.newLinkedList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.customerSaleAreaRepository.lambdaQuery().in(CustomerSaleAreaEntity::getCustomerCode, code)).eq(TenantOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newLinkedList();
        }
        return list;
    }
}

