/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.enums.FreezeStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.local.entity.CustomerEntity;
import com.biz.crm.mdm.business.customer.local.entity.CustomerROrgEntity;
import com.biz.crm.mdm.business.customer.local.entity.DealerSalesRegionEntity;
import com.biz.crm.mdm.business.customer.local.entity.SupplyRelationshipEntity;
import com.biz.crm.mdm.business.customer.local.model.MultipleConditionModel;
import com.biz.crm.mdm.business.customer.local.repository.CustomerROrgRepository;
import com.biz.crm.mdm.business.customer.local.repository.CustomerRepository;
import com.biz.crm.mdm.business.customer.local.repository.DealerOrgRelationshipRepository;
import com.biz.crm.mdm.business.customer.local.repository.DealerSalesRegionRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerBillService;
import com.biz.crm.mdm.business.customer.local.service.CustomerContactService;
import com.biz.crm.mdm.business.customer.local.service.CustomerDockingService;
import com.biz.crm.mdm.business.customer.local.service.CustomerMediaService;
import com.biz.crm.mdm.business.customer.local.service.CustomerROrgService;
import com.biz.crm.mdm.business.customer.local.service.CustomerSaleAreaService;
import com.biz.crm.mdm.business.customer.local.service.CustomerService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerContactDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerEventDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerNebulaEventDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerPageDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerRebindOrgDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerSelectDto;
import com.biz.crm.mdm.business.customer.sdk.dto.DealerSalesRegionDto;
import com.biz.crm.mdm.business.customer.sdk.dto.SupplyRelationshipDto;
import com.biz.crm.mdm.business.customer.sdk.enums.CustomerLevelEnum;
import com.biz.crm.mdm.business.customer.sdk.event.CustomerEventListener;
import com.biz.crm.mdm.business.customer.sdk.event.CustomerNebulaEventListener;
import com.biz.crm.mdm.business.customer.sdk.service.SupplyRelationshipSdkService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerPageVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerRelateOrgVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerServiceImpl
implements CustomerService {
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private CustomerRepository customerRepository;
    @Autowired(required=false)
    private CustomerBillService customerBillService;
    @Autowired(required=false)
    private CustomerContactService customerContactService;
    @Autowired(required=false)
    private CustomerDockingService customerDockingService;
    @Autowired(required=false)
    private CustomerSaleAreaService customerSaleAreaService;
    @Autowired(required=false)
    private CustomerMediaService customerMediaService;
    @Autowired(required=false)
    private CustomerROrgService customerROrgService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private DealerOrgRelationshipRepository dealerOrgRelationshipRepository;
    @Autowired(required=false)
    private SupplyRelationshipSdkService supplyRelationshipSdkService;
    @Autowired(required=false)
    private DealerSalesRegionRepository dealerSalesRegionRepository;
    @Autowired(required=false)
    private CustomerROrgRepository customerROrgRepository;
    public static final String CUSTOMER_PROCESS_NAME = "\u7ecf\u9500\u5546\u5ba1\u6279\u6d41\u7a0b";
    private static volatile Cache<String, List<CustomerEntity>> cache = null;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Value(value="${crm.business.customer.process-key:}")
    private String defaultProcessKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CustomerServiceImpl() {
        if (cache != null) return;
        Class<CustomerServiceImpl> clazz = CustomerServiceImpl.class;
        synchronized (CustomerServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    @Transactional
    public CustomerEntity create(CustomerDto dto) {
        this.createValidation(dto);
        this.validateContacts(dto);
        if (StringUtils.isEmpty((CharSequence)dto.getCustomerCode())) {
            String ruleCode = StringUtils.join((Object[])new String[]{"KH", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
            String code = (String)this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
            dto.setCustomerCode(code);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<CustomerEntity> list = this.customerRepository.findByCodes(Lists.newArrayList((Object[])new String[]{dto.getCustomerCode()}), dto.getTenantCode());
        CustomerVo oldVo = null;
        if (StringUtils.isEmpty((CharSequence)dto.getId())) {
            Validate.isTrue((boolean)CollectionUtils.isEmpty(list), (String)"\u5ba2\u6237\u7f16\u7801\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        } else {
            Validate.isTrue((list.size() == 1 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7f16\u7801\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
            oldVo = this.findByCustomerEntity(list.get(0));
        }
        CustomerEntity entity = (CustomerEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CustomerEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setLockState(FreezeStatusEnum.NORMAL.getCode());
        entity.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDealerId(dto.getCustomerCode());
        this.customerRepository.saveOrUpdate((Object)entity);
        dto.setDealerId(entity.getDealerId());
        dto.setId(entity.getId());
        this.rebindRelationData(dto);
        List dealerSalesRegionDtoList = dto.getDealerSalesRegionDtoList();
        List saleAreaEntities = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)dealerSalesRegionDtoList, DealerSalesRegionDto.class, DealerSalesRegionEntity.class, HashSet.class, ArrayList.class, new String[0]);
        saleAreaEntities.stream().forEach(o -> {
            o.setDealerId(entity.getDealerId());
            o.setDealerCode(entity.getCustomerCode());
            o.setDealerName(entity.getCustomerName());
            o.setTenantCode(TenantUtils.getTenantCode());
            o.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            o.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        });
        this.dealerSalesRegionRepository.saveOrUpdateBatch(saleAreaEntities);
        List supplyRelationshipDtos = dto.getSupplyRelationshipDtos();
        supplyRelationshipDtos.forEach(o -> o.setBuyerId(entity.getDealerId()));
        this.supplyRelationshipSdkService.savaOrUpdate(supplyRelationshipDtos, dto.getDealerId());
        CustomerEventDto customerEventDto = new CustomerEventDto();
        customerEventDto.setOriginal(null);
        CustomerVo customerVo = (CustomerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, CustomerVo.class, HashSet.class, ArrayList.class, new String[]{"dockingList", "contactList", "saleAreaList", "billList", "fileList"});
        customerEventDto.setNewest(customerVo);
        entity.setOrgCode(dto.getOrgCode());
        entity.setDealerSalesRegionEntityList(saleAreaEntities);
        entity.setSupplyRelationshipEntityList((List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)dto.getSupplyRelationshipDtos(), SupplyRelationshipDto.class, SupplyRelationshipEntity.class, HashSet.class, ArrayList.class, new String[0]));
        return entity;
    }

    @Override
    public CustomerEntity importCreate(CustomerDto dto) {
        this.createValidation(dto);
        this.validateContacts(dto);
        if (StringUtils.isEmpty((CharSequence)dto.getCustomerCode())) {
            String ruleCode = StringUtils.join((Object[])new String[]{"KH", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
            String code = (String)this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
            dto.setCustomerCode(code);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<CustomerEntity> list = this.customerRepository.findByCodes(Lists.newArrayList((Object[])new String[]{dto.getCustomerCode()}), dto.getTenantCode());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(list), (String)"\u5ba2\u6237\u7f16\u7801\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        CustomerEntity entity = (CustomerEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CustomerEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setLockState(FreezeStatusEnum.NORMAL.getCode());
        entity.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        entity.setTenantCode(TenantUtils.getTenantCode());
        this.customerRepository.save((Object)entity);
        this.rebindRelationData(dto);
        return entity;
    }

    @Override
    @Transactional
    public CustomerEntity update(CustomerDto dto) {
        this.updateValidation(dto);
        this.validateContacts(dto);
        CustomerEntity entity = this.customerRepository.findDetailsByIdOrCode(dto.getId(), null, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)entity), (String)"\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)entity.getCustomerCode().equals(dto.getCustomerCode()), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        CustomerEntity updateEntity = (CustomerEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CustomerEntity.class, HashSet.class, ArrayList.class, new String[0]));
        updateEntity.setTenantCode(TenantUtils.getTenantCode());
        this.customerRepository.updateByIdAndTenantCode(updateEntity, TenantUtils.getTenantCode());
        CustomerVo oldVo = this.findByCustomerEntity(entity);
        this.rebindRelationData(dto);
        CustomerEntity detailsByIdOrCode = this.customerRepository.findDetailsByIdOrCode(dto.getId(), null, TenantUtils.getTenantCode());
        CustomerEventDto customerEventDto = new CustomerEventDto();
        customerEventDto.setOriginal(oldVo);
        CustomerVo nowVo = (CustomerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)detailsByIdOrCode, CustomerVo.class, HashSet.class, ArrayList.class, new String[]{"dockingList", "contactList", "saleAreaList", "billList", "fileList"});
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgCode())) {
            CustomerRelateOrgVo curOrgVo = new CustomerRelateOrgVo();
            curOrgVo.setOrgCode(dto.getOrgCode());
            nowVo.setOrgList((List)Lists.newArrayList((Object[])new CustomerRelateOrgVo[]{curOrgVo}));
        }
        customerEventDto.setNewest(nowVo);
        SerializableBiConsumer & Serializable onUpdate = CustomerEventListener::onUpdate;
        return updateEntity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List<CustomerEntity> entities = this.customerRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((CollectionUtils.isNotEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.customerRepository.updateDelFlagByIds(ids);
        CustomerEventDto customerEventDto = new CustomerEventDto();
        List customerVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, CustomerEntity.class, CustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)customerVos)) {
            List<CustomerROrgEntity> customerOrgList;
            Map<Object, Object> map = Maps.newHashMap();
            Set<String> customerCodes = customerVos.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCustomerCode())).map(CustomerVo::getCustomerCode).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(customerCodes) && !CollectionUtils.isEmpty(customerOrgList = this.customerROrgService.findByCustomerCodes(customerCodes))) {
                map = customerOrgList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getCustomerCode(), a.getOrgCode()})).collect(Collectors.groupingBy(CustomerROrgEntity::getCustomerCode, Collectors.mapping(CustomerROrgEntity::getOrgCode, Collectors.toSet())));
            }
            for (CustomerVo customerVo : customerVos) {
                Set orgCodes = (Set)map.get(customerVo.getCustomerCode());
                if (CollectionUtils.isNotEmpty((Collection)orgCodes)) {
                    LinkedList orgList = Lists.newLinkedList();
                    for (String orgCode : orgCodes) {
                        CustomerRelateOrgVo cur = new CustomerRelateOrgVo();
                        cur.setOrgCode(orgCode);
                        orgList.add(cur);
                    }
                    customerVo.setOrgList((List)orgList);
                }
                customerEventDto.setOriginal(customerVo);
                customerEventDto.setNewest(null);
                SerializableBiConsumer & Serializable intersect = CustomerEventListener::onDelete;
            }
        }
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List<CustomerEntity> entities = this.customerRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((CollectionUtils.isNotEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u542f\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.customerRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(entities, CustomerEntity.class, CustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (CustomerVo item : voList) {
            CustomerEventDto customerEventDto = new CustomerEventDto();
            customerEventDto.setOriginal(item);
            SerializableBiConsumer & Serializable intersect = CustomerEventListener::onEnable;
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List<CustomerEntity> entities = this.customerRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((CollectionUtils.isNotEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u7981\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.customerRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(entities, CustomerEntity.class, CustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (CustomerVo item : voList) {
            CustomerEventDto customerEventDto = new CustomerEventDto();
            customerEventDto.setOriginal(item);
            SerializableBiConsumer & Serializable intersect = CustomerEventListener::onDisable;
        }
    }

    @Override
    @Transactional
    public void freezeBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List<CustomerEntity> entities = this.customerRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((CollectionUtils.isNotEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u51bb\u7ed3\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.customerRepository.freezeBatch(ids, FreezeStatusEnum.FREEZE);
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(entities, CustomerEntity.class, CustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (CustomerVo item : voList) {
            CustomerEventDto customerEventDto = new CustomerEventDto();
            customerEventDto.setOriginal(item);
            SerializableBiConsumer & Serializable intersect = CustomerEventListener::onFreeze;
        }
    }

    @Override
    @Transactional
    public void unfreezeBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List<CustomerEntity> entities = this.customerRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((CollectionUtils.isNotEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u89e3\u51bb\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.customerRepository.freezeBatch(ids, FreezeStatusEnum.NORMAL);
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(entities, CustomerEntity.class, CustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (CustomerVo item : voList) {
            CustomerEventDto customerEventDto = new CustomerEventDto();
            customerEventDto.setOriginal(item);
            SerializableBiConsumer & Serializable intersect = CustomerEventListener::onUnfreeze;
        }
    }

    @Override
    public Page<CustomerEntity> findByCustomerSelectDto(Pageable pageable, CustomerSelectDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (CustomerSelectDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new CustomerSelectDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.customerRepository.findByCustomerSelectDto(pageable, dto);
    }

    @Override
    public CustomerEntity findDetailsByIdOrCode(String id, String customerCode) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{id, customerCode})) {
            return null;
        }
        return this.customerRepository.findDetailsByIdOrCode(id, customerCode, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public void rebindOrg(CustomerRebindOrgDto dto) {
        Validate.notBlank((CharSequence)dto.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOriginOrgCode(), (String)"\u7f3a\u5931\u6e90\u7ec4\u7ec7\u7f16\u7801", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getCustomerCodeList()), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801", (Object[])new Object[0]);
        this.customerROrgService.rebindOrgCode(dto.getOrgCode(), dto.getOriginOrgCode(), dto.getCustomerCodeList());
    }

    @Override
    @Transactional
    public void rebindCustomerOrg(CustomerRebindOrgDto dto) {
        Validate.notBlank((CharSequence)dto.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOriginOrgCode(), (String)"\u7f3a\u5931\u6e90\u7ec4\u7ec7\u7f16\u7801", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getCustomerCodeList()), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801", (Object[])new Object[0]);
        this.customerRepository.rebindCustomerOrgCode(dto.getOrgCode(), dto.getOriginOrgCode(), dto.getCustomerCodeList(), TenantUtils.getTenantCode());
    }

    @Override
    public List<CustomerEntity> findByMultipleConditionModel(MultipleConditionModel model) {
        if (Objects.isNull(model)) {
            return Lists.newArrayList();
        }
        model.setTenantCode(TenantUtils.getTenantCode());
        return this.customerRepository.findByMultipleConditionModel(model);
    }

    @Override
    public List<CustomerEntity> findByOrgCodes(List<String> orgCodeList) {
        if (CollectionUtils.isEmpty(orgCodeList)) {
            return Lists.newArrayList();
        }
        return this.customerRepository.findByOrgCodes(orgCodeList);
    }

    @Override
    public List<CustomerEntity> findByCustomerCodes(List<String> customerCodeList) {
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return Lists.newArrayList();
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), customerCodeList});
        List<CustomerEntity> graph = (List<CustomerEntity>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.customerRepository.findByCodes(customerCodeList, TenantUtils.getTenantCode());
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    private void rebindRelationData(CustomerDto dto) {
        this.customerBillService.rebindCustomerCode(dto.getBillList(), dto.getCustomerCode());
        this.customerContactService.rebindCustomerCode(dto.getContactList(), dto.getCustomerCode());
        this.customerMediaService.rebindCustomerCode(dto.getFileList(), dto.getCustomerCode());
        this.customerDockingService.rebindCustomerCode(dto.getDockingList(), dto.getCustomerCode());
        this.customerROrgService.rebindCustomerCode(dto);
    }

    private void createValidation(CustomerDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getCustomerName(), (String)"\u7f3a\u5931\u5ba2\u6237\u540d\u79f0", (Object[])new Object[0]);
        Validate.isTrue((dto.getCustomerName().length() < 128 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void updateValidation(CustomerDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)dto.getCustomerLevel()) && CustomerLevelEnum.T2.getDictCode().equals(dto.getCustomerLevel())) {
            Validate.notBlank((CharSequence)dto.getParentCustomerCode(), (String)"\u4e0a\u7ea7\u7ecf\u9500\u5546\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerName(), (String)"\u7f3a\u5931\u5ba2\u6237\u540d\u79f0", (Object[])new Object[0]);
        Validate.isTrue((dto.getCustomerCode().length() < 128 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dto.getCustomerCode().length() < 64 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public Page<CustomerEntity> findByParentCustomerIsNull(Pageable pageable) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        String status = EnableStatusEnum.ENABLE.getCode();
        return this.customerRepository.findByParentCustomerIsNull(pageable, status);
    }

    @Override
    public Page<CustomerEntity> findChildrenByCustomerCode(Pageable pageable, String customerCode) {
        String tenantCode = TenantUtils.getTenantCode();
        return this.customerRepository.findChildrenByCustomerCode(pageable, tenantCode, customerCode);
    }

    @Override
    public Page<CustomerEntity> findByTagId(Pageable pageable, String tagId) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (StringUtils.isBlank((CharSequence)tagId)) {
            return new Page();
        }
        return this.customerRepository.findByTagId(pageable, tagId);
    }

    @Override
    public List<CustomerEntity> findByCustomerCodeLikeOrCustomerNameLike(String customerCodeLikeOrNameLike) {
        return this.customerRepository.findByCustomerCodeLikeOrCustomerNameLike(customerCodeLikeOrNameLike);
    }

    @Override
    public List<CustomerEntity> findByStatus(String status) {
        if (StringUtils.isBlank((CharSequence)status)) {
            return null;
        }
        return this.customerRepository.findByStatus(status);
    }

    @Override
    public void onProcessSuccess(CustomerEntity customer) {
        CustomerNebulaEventDto customerNebulaEventDto = (CustomerNebulaEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)customer, CustomerNebulaEventDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onCreateNebulaEvent = CustomerNebulaEventListener::onCreate;
    }

    private void validateContacts(CustomerDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        List contacts = dto.getContactList();
        if (CollectionUtils.isEmpty((Collection)contacts)) {
            return;
        }
        List list = contacts.stream().filter(a -> !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{a.getContactName(), a.getContactPhone()})).collect(Collectors.toList());
        dto.setContactList(list);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (CustomerContactDto contact : contacts) {
            if (!StringUtils.isNotBlank((CharSequence)contact.getContactName()) && !StringUtils.isNotBlank((CharSequence)contact.getContactPhone()) && Objects.isNull(contact.getContactMain())) continue;
            Validate.notBlank((CharSequence)contact.getContactPhone(), (String)"\u7f3a\u5931\u8054\u7cfb\u7535\u8bdd", (Object[])new Object[0]);
            Validate.notNull((Object)contact.getContactMain(), (String)"\u8bf7\u9009\u62e9\u662f\u5426\u662f\u4e3b\u8054\u7cfb\u4eba", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)contact.getContactName(), (String)"\u7f3a\u5931\u59d3\u540d", (Object[])new Object[0]);
        }
        List contanctsByMain = contacts.stream().filter(o -> o.getContactMain() == true).collect(Collectors.toList());
        Validate.isTrue((contanctsByMain.size() == 1 ? 1 : 0) != 0, (String)"\u5fc5\u987b\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a\u4e3b\u8054\u7cfb\u4eba", (Object[])new Object[0]);
    }

    private String commitProcess(CustomerDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        String processKey = processBusiness.getProcessKey();
        if (StringUtils.isBlank((CharSequence)processKey)) {
            processBusiness.setProcessKey(this.defaultProcessKey);
        } else {
            processBusiness.setProcessKey(processKey);
        }
        processBusiness.setBusinessNo(dto.getCustomerCode());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        processBusiness.setBusinessCode("customer_create");
        processBusiness.setProcessTitle(CUSTOMER_PROCESS_NAME);
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        return processBusinessVo.getProcessNo();
    }

    private CustomerVo findByCustomerEntity(CustomerEntity entity) {
        if (Objects.isNull((Object)entity) || StringUtils.isBlank((CharSequence)entity.getCustomerCode())) {
            return null;
        }
        CustomerVo vo = (CustomerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, CustomerVo.class, HashSet.class, ArrayList.class, new String[]{"dockingList", "contactList", "saleAreaList", "billList", "fileList"});
        List<CustomerROrgEntity> orgList = this.customerROrgService.findByCustomerCodes(Sets.newHashSet((Object[])new String[]{entity.getCustomerCode()}));
        if (CollectionUtils.isEmpty(orgList)) {
            return vo;
        }
        LinkedList relateOrgList = Lists.newLinkedList();
        for (CustomerROrgEntity item : orgList) {
            CustomerRelateOrgVo curOrgVo = new CustomerRelateOrgVo();
            curOrgVo.setOrgCode(item.getOrgCode());
            relateOrgList.add(curOrgVo);
        }
        vo.setOrgList((List)relateOrgList);
        return vo;
    }

    @Override
    public Page<CustomerPageVo> findByCustomerPageDto(Pageable pageable, CustomerPageDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return this.customerRepository.findByCustomerPageDto((Page<CustomerPageVo>)page, dto);
    }
}

