/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.internal;

import com.biz.crm.mdm.business.customer.local.entity.CustomerTagRuleEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerTagRuleRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerTagRuleService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerTagRuleServiceImpl
implements CustomerTagRuleService {
    @Autowired(required=false)
    private CustomerTagRuleRepository customerTagRuleRepository;

    @Override
    public void create(Collection<CustomerTagRuleEntity> customerTagRuleEntities) {
        this.createValidate(customerTagRuleEntities);
        customerTagRuleEntities.stream().forEach(customerTagRuleEntity -> customerTagRuleEntity.setTenantCode(TenantUtils.getTenantCode()));
        this.customerTagRuleRepository.saveBatch(customerTagRuleEntities);
    }

    @Override
    @Transactional
    public void update(Collection<CustomerTagRuleEntity> customerTagRuleEntities) {
        this.updateValidate(customerTagRuleEntities);
        customerTagRuleEntities.stream().forEach(customerTagRuleEntity -> customerTagRuleEntity.setTenantCode(TenantUtils.getTenantCode()));
        this.customerTagRuleRepository.updateBatchByIdAndTenantCode(customerTagRuleEntities, TenantUtils.getTenantCode());
    }

    private void updateValidate(Collection<CustomerTagRuleEntity> customerTagRuleEntities) {
        Validate.notEmpty(customerTagRuleEntities, (String)"\u66f4\u65b0\u89c4\u5219\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (CustomerTagRuleEntity rule : customerTagRuleEntities) {
            Validate.notBlank((CharSequence)rule.getCustomerTagId(), (String)"\u66f4\u65b0\u89c4\u5219\u65f6,\u6807\u7b7e\u5173\u8054id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)rule.getTagAttributes(), (String)"\u66f4\u65b0\u89c4\u5219\u65f6,\u6807\u7b7e\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)rule.getTagSubdivision(), (String)"\u66f4\u65b0\u89c4\u5219\u65f6,\u6807\u7b7e\u7ec6\u5206\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)rule.getTagExpression(), (String)"\u66f4\u65b0\u89c4\u5219\u65f6,\u8ba1\u7b97\u7b26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    private void createValidate(Collection<CustomerTagRuleEntity> customerTagRuleEntities) {
        Validate.notEmpty(customerTagRuleEntities, (String)"\u521b\u5efa\u89c4\u5219\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (CustomerTagRuleEntity rule : customerTagRuleEntities) {
            Validate.notBlank((CharSequence)rule.getCustomerTagId(), (String)"\u521b\u5efa\u89c4\u5219\u65f6,\u6807\u7b7e\u5173\u8054id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)rule.getTagAttributes(), (String)"\u521b\u5efa\u89c4\u5219\u65f6,\u6807\u7b7e\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)rule.getTagSubdivision(), (String)"\u521b\u5efa\u89c4\u5219\u65f6,\u6807\u7b7e\u7ec6\u5206\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)rule.getTagExpression(), (String)"\u521b\u5efa\u89c4\u5219\u65f6,\u8ba1\u7b97\u7b26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

