/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.internal;

import cn.hutool.core.collection.CollUtil;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.local.entity.CustomerEntity;
import com.biz.crm.mdm.business.customer.local.entity.CustomerTagEntity;
import com.biz.crm.mdm.business.customer.local.entity.CustomerTagMappingEntity;
import com.biz.crm.mdm.business.customer.local.entity.CustomerTagRuleEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerTagMappingRepository;
import com.biz.crm.mdm.business.customer.local.repository.CustomerTagRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerService;
import com.biz.crm.mdm.business.customer.local.service.CustomerTagRuleService;
import com.biz.crm.mdm.business.customer.local.service.CustomerTagService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerTagDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerTagRuleDto;
import com.biz.crm.mdm.business.customer.sdk.enums.TagUpdateTypeEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerTagService")
public class CustomerTagServiceImpl
implements CustomerTagService {
    @Autowired(required=false)
    private CustomerTagRepository customerTagRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerTagRuleService customerTagRuleService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private CustomerService customerService;
    @Autowired(required=false)
    private CustomerTagMappingRepository customerTagMappingRepository;

    @Override
    public List<CustomerTagEntity> findByCustomerCode(String customerCode) {
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return Lists.newArrayList();
        }
        return this.customerTagRepository.findByCustomerCode(customerCode);
    }

    @Override
    public List<CustomerTagEntity> findByCustomerCodes(List<String> customerCodes) {
        if (CollUtil.isEmpty(customerCodes)) {
            return Lists.newArrayList();
        }
        return this.customerTagRepository.findByCustomerCodes(customerCodes);
    }

    @Override
    @Transactional
    public CustomerTagEntity create(CustomerTagDto dto) {
        this.createValidation(dto);
        CustomerTagEntity entity = (CustomerTagEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CustomerTagEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(DelFlagStatusEnum.NORMAL.getCode());
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        String account = loginUser.getAccount();
        String username = loginUser.getUsername();
        Date date = new Date();
        entity.setCreateAccount(account);
        entity.setCreateName(username);
        entity.setCreateTime(date);
        entity.setModifyAccount(account);
        entity.setModifyName(username);
        entity.setModifyTime(date);
        entity.setTenantCode(TenantUtils.getTenantCode());
        this.customerTagRepository.save((Object)entity);
        CustomerTagMappingEntity mappingEntity = new CustomerTagMappingEntity();
        mappingEntity.setTagId(entity.getId());
        mappingEntity.setCustomerCode(dto.getCustomerCode());
        mappingEntity.setTenantCode(TenantUtils.getTenantCode());
        this.customerTagMappingRepository.save((Object)mappingEntity);
        if (CollectionUtils.isNotEmpty((Collection)dto.getRules())) {
            Collection customerTagRuleEntities = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getRules(), CustomerTagRuleDto.class, CustomerTagRuleEntity.class, HashSet.class, ArrayList.class, new String[0]);
            customerTagRuleEntities.stream().forEach(item -> item.setCustomerTagId(entity.getId()));
            customerTagRuleEntities.stream().forEach(item -> item.setTenantCode(TenantUtils.getTenantCode()));
            this.customerTagRuleService.create(customerTagRuleEntities);
        }
        return entity;
    }

    @Override
    @Transactional
    public CustomerTagEntity update(CustomerTagDto dto) {
        this.updateValidation(dto);
        CustomerTagEntity entity = (CustomerTagEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CustomerTagEntity.class, HashSet.class, ArrayList.class, new String[0]));
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        entity.setModifyAccount(loginUser.getAccount());
        entity.setModifyName(loginUser.getUsername());
        entity.setModifyTime(new Date());
        this.customerTagRepository.updateByIdAndTenantCode(entity, TenantUtils.getTenantCode());
        this.customerTagMappingRepository.deleteByTagIds(Collections.singletonList(entity.getId()));
        CustomerTagMappingEntity mappingEntity = new CustomerTagMappingEntity();
        mappingEntity.setTagId(entity.getId());
        mappingEntity.setCustomerCode(dto.getCustomerCode());
        mappingEntity.setTenantCode(TenantUtils.getTenantCode());
        this.customerTagMappingRepository.save((Object)mappingEntity);
        if (CollectionUtils.isNotEmpty((Collection)dto.getRules())) {
            Collection customerTagRuleEntities = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getRules(), CustomerTagRuleDto.class, CustomerTagRuleEntity.class, HashSet.class, ArrayList.class, new String[0]);
            this.customerTagRuleService.update(customerTagRuleEntities);
        }
        return entity;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        this.customerTagRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE.getCode());
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        this.customerTagRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE.getCode());
    }

    @Override
    public CustomerTagEntity findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.customerTagRepository.findDetailById(id);
    }

    @Override
    @Transactional
    public void handleCustomerTagTask() {
        List<CustomerEntity> customers = this.customerService.findByStatus(EnableStatusEnum.ENABLE.getCode());
        for (CustomerEntity customer : customers) {
            BigDecimal sale = BigDecimal.ZERO;
            BigDecimal target = BigDecimal.ZERO;
            Integer num = 0;
            LinkedList<String> tagList = this.handleTag(sale, target, num);
            ArrayList<CustomerTagMappingEntity> mappings = new ArrayList<CustomerTagMappingEntity>();
            for (String tag : tagList) {
                CustomerTagMappingEntity mappingEntity = new CustomerTagMappingEntity();
                mappingEntity.setTagId(tag);
                mappingEntity.setCustomerCode(customer.getCustomerCode());
                mappingEntity.setTenantCode(customer.getTenantCode());
                mappings.add(mappingEntity);
            }
            this.customerTagMappingRepository.saveBatch(mappings);
        }
    }

    private LinkedList<String> handleTag(BigDecimal sale, BigDecimal target, Integer num) {
        List<CustomerTagEntity> tags = this.customerTagRepository.findDetailByStatusAndUpdateType(EnableStatusEnum.ENABLE.getCode(), true);
        if (CollectionUtils.isEmpty(tags)) {
            return Lists.newLinkedList();
        }
        LinkedList<String> tagList = new LinkedList<String>();
        for (CustomerTagEntity tag : tags) {
            Boolean bool;
            List<CustomerTagRuleEntity> rules = tag.getRules();
            if (CollectionUtils.isEmpty(rules) || !(bool = this.handleRules(rules, sale, target, num)).booleanValue()) continue;
            tagList.add(tag.getId());
        }
        return tagList;
    }

    private Boolean handleRules(List<CustomerTagRuleEntity> rules, BigDecimal sale, BigDecimal target, Integer num) {
        Boolean flag = false;
        block10: for (CustomerTagRuleEntity rule : rules) {
            switch (rule.getTagAttributes()) {
                case "sale": {
                    flag = this.handleCompare(rule, sale);
                    continue block10;
                }
                case "channel": {
                    flag = this.handleCompare(rule, target);
                    continue block10;
                }
                case "credit": {
                    flag = this.handleCompare(rule, new BigDecimal(num));
                    continue block10;
                }
            }
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u8be5\u5c5e\u6027");
        }
        return flag;
    }

    private Boolean handleCompare(CustomerTagRuleEntity rule, BigDecimal data) {
        switch (rule.getTagExpression()) {
            case "equal": {
                if (data.compareTo(rule.getExpressionAmount()) != 0) break;
                return true;
            }
            case "more_than": {
                if (data.compareTo(rule.getExpressionAmount()) != 1) break;
                return true;
            }
            case "less_than": {
                if (data.compareTo(rule.getExpressionAmount()) != -1) break;
                return true;
            }
            case "interval": {
                if (data.compareTo(rule.getExpressionAmount()) == -1 || data.compareTo(rule.getExpressionAmountMax()) == 1) break;
                return true;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u8be5\u5c5e\u6027\u7ec6\u5206");
            }
        }
        return false;
    }

    private void updateValidation(CustomerTagDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u66f4\u65b0\u65f6\u7f3a\u5931id", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTagName(), (String)"\u7f3a\u5931\u6807\u7b7e\u540d\u79f0", (Object[])new Object[0]);
        CustomerTagEntity entity = this.customerTagRepository.findByTagName(dto.getTagName());
        Validate.isTrue((entity != null && entity.getId().equals(dto.getId()) ? 1 : 0) != 0, (String)"\u6807\u7b7e\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getUpdateType(), (String)"\u7f3a\u5931\u66f4\u65b0\u65b9\u5f0f", (Object[])new Object[0]);
        if (TagUpdateTypeEnum.TIMING.getDictCode().equals(String.valueOf(dto.getUpdateType()))) {
            Validate.notNull((Object)dto.getUpdateCycle(), (String)"\u7f3a\u5931\u66f4\u65b0\u5468\u671f", (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List<CustomerTagEntity> entities = this.customerTagRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((CollectionUtils.isNotEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.customerTagRepository.deleteBatch(ids);
        this.customerTagMappingRepository.deleteByTagIds(ids);
    }

    private void createValidation(CustomerTagDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setId(null);
        Validate.notBlank((CharSequence)dto.getTagName(), (String)"\u7f3a\u5931\u6807\u7b7e\u540d\u79f0", (Object[])new Object[0]);
        CustomerTagEntity entity = this.customerTagRepository.findByTagName(dto.getTagName());
        Validate.isTrue((entity == null ? 1 : 0) != 0, (String)"\u6807\u7b7e\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getUpdateType(), (String)"\u7f3a\u5931\u66f4\u65b0\u65b9\u5f0f", (Object[])new Object[0]);
        if (TagUpdateTypeEnum.TIMING.getDictCode().equals(String.valueOf(dto.getUpdateType()))) {
            Validate.notNull((Object)dto.getUpdateCycle(), (String)"\u7f3a\u5931\u66f4\u65b0\u5468\u671f", (Object[])new Object[0]);
        }
    }
}

