/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.internal;

import com.biz.crm.mdm.business.customer.local.entity.DealerOrgRelationshipEntity;
import com.biz.crm.mdm.business.customer.local.repository.DealerOrgRelationshipRepository;
import com.biz.crm.mdm.business.customer.sdk.service.DealerOrgRelationshipService;
import com.biz.crm.mdm.business.customer.sdk.vo.DealerOrgRelationshipVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DealerOrgRelationshipServiceImpl
implements DealerOrgRelationshipService {
    private static final Logger log = LoggerFactory.getLogger(DealerOrgRelationshipServiceImpl.class);
    @Autowired(required=false)
    private DealerOrgRelationshipRepository dealerOrgRelationshipRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<DealerOrgRelationshipVo> listByDealerCodes(List<String> dealerCodes) {
        if (CollectionUtils.isEmpty(dealerCodes)) {
            return Lists.newArrayList();
        }
        List<DealerOrgRelationshipEntity> entities = this.dealerOrgRelationshipRepository.listByDealerCodes(dealerCodes);
        ArrayList vos = (ArrayList)this.nebulaToolkitService.copyCollectionByBlankList(entities, DealerOrgRelationshipEntity.class, DealerOrgRelationshipVo.class, HashSet.class, ArrayList.class, new String[0]);
        return vos;
    }

    public Map<String, List<DealerOrgRelationshipVo>> findDealerOrgRelationshipMap(List<String> dealerIds) {
        if (CollectionUtils.isEmpty(dealerIds)) {
            return Maps.newHashMap();
        }
        List<DealerOrgRelationshipEntity> entities = this.dealerOrgRelationshipRepository.listByDealerIds(dealerIds);
        ArrayList vos = (ArrayList)this.nebulaToolkitService.copyCollectionByBlankList(entities, DealerOrgRelationshipEntity.class, DealerOrgRelationshipVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<DealerOrgRelationshipVo>> listMap = vos.stream().collect(Collectors.groupingBy(DealerOrgRelationshipVo::getDealerId));
        return listMap;
    }
}

