/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.local.entity.SupplyRelationshipDetailEntity;
import com.biz.crm.mdm.business.customer.local.entity.SupplyRelationshipEntity;
import com.biz.crm.mdm.business.customer.local.repository.SupplyRelationshipDetailRepository;
import com.biz.crm.mdm.business.customer.local.repository.SupplyRelationshipRepository;
import com.biz.crm.mdm.business.customer.sdk.dto.SupplyRelationshipDetailDto;
import com.biz.crm.mdm.business.customer.sdk.dto.SupplyRelationshipDto;
import com.biz.crm.mdm.business.customer.sdk.service.SupplyRelationshipSdkService;
import com.biz.crm.mdm.business.customer.sdk.vo.SupplyRelationshipDetailVo;
import com.biz.crm.mdm.business.customer.sdk.vo.SupplyRelationshipVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplyRelationshipSdkServiceImpl
implements SupplyRelationshipSdkService {
    private static final Logger log = LoggerFactory.getLogger(SupplyRelationshipSdkServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SupplyRelationshipRepository supplyRelationshipRepository;
    @Autowired(required=false)
    private SupplyRelationshipDetailRepository detailRepository;

    public void savaOrUpdate(List<SupplyRelationshipDto> dtos, String buyerId) {
        List<SupplyRelationshipEntity> oldEntities;
        this.createValidate(dtos);
        if (StringUtils.isBlank((CharSequence)buyerId)) {
            buyerId = dtos.get(0).getBuyerId();
        }
        if (CollectionUtils.isNotEmpty(oldEntities = this.supplyRelationshipRepository.findByBuyerId(buyerId))) {
            List<String> ids = oldEntities.stream().map(o -> o.getId()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            this.supplyRelationshipRepository.removeByBuyerId(buyerId);
            this.detailRepository.removeBySupplyRelationshipIds(ids);
        }
        ArrayList entities = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList(dtos, SupplyRelationshipDto.class, SupplyRelationshipEntity.class, HashSet.class, ArrayList.class, new String[0]);
        for (SupplyRelationshipEntity entity : entities) {
            entity.setId(null);
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setBuyerId(buyerId);
        }
        this.supplyRelationshipRepository.saveBatch(entities);
        Map dtoMap = dtos.stream().collect(Collectors.toMap(o -> o.getBuyerId() + o.getSupplierId(), Function.identity(), (v1, v2) -> v2));
        Map entityMap = entities.stream().collect(Collectors.toMap(o -> o.getBuyerId() + o.getSupplierId(), Function.identity(), (v1, v2) -> v2));
        ArrayList<SupplyRelationshipDetailEntity> detailEntities = new ArrayList<SupplyRelationshipDetailEntity>();
        for (Map.Entry entry : dtoMap.entrySet()) {
            SupplyRelationshipEntity entity = (SupplyRelationshipEntity)((Object)entityMap.get(entry.getKey()));
            for (SupplyRelationshipDetailDto dto : ((SupplyRelationshipDto)entry.getValue()).getDetailDtos()) {
                SupplyRelationshipDetailEntity detailEntity = (SupplyRelationshipDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SupplyRelationshipDetailEntity.class, HashSet.class, ArrayList.class, new String[0]));
                detailEntity.setId(null);
                detailEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                detailEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                detailEntity.setTenantCode(TenantUtils.getTenantCode());
                detailEntity.setSupplyRelationshipId(entity.getId());
                detailEntities.add(detailEntity);
            }
        }
        this.detailRepository.saveBatch(detailEntities);
    }

    public List<SupplyRelationshipVo> findByBuyerId(String buyerId) {
        if (StringUtils.isBlank((CharSequence)buyerId)) {
            return Lists.newArrayList();
        }
        List<SupplyRelationshipEntity> entities = this.supplyRelationshipRepository.findByBuyerId(buyerId);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newArrayList();
        }
        List<String> ids = entities.stream().map(o -> o.getId()).collect(Collectors.toList());
        List<SupplyRelationshipDetailEntity> detailEntities = this.detailRepository.findBySupplyRelationshipIds(ids);
        ArrayList supplyRelationshipVos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList(entities, SupplyRelationshipEntity.class, SupplyRelationshipVo.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList detailVos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList(detailEntities, SupplyRelationshipDetailEntity.class, SupplyRelationshipDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<SupplyRelationshipDetailVo>> detailVoListMap = detailVos.stream().collect(Collectors.groupingBy(SupplyRelationshipDetailVo::getSupplyRelationshipId));
        supplyRelationshipVos.forEach(o -> o.setDetailVos((List)detailVoListMap.get(o.getId())));
        return supplyRelationshipVos;
    }

    public Map<String, List<SupplyRelationshipVo>> findByBuyerIds(List<String> buyerIds) {
        if (CollectionUtils.isEmpty(buyerIds)) {
            return Maps.newHashMap();
        }
        List<SupplyRelationshipEntity> entities = this.supplyRelationshipRepository.findByBuyerIds(buyerIds);
        if (CollectionUtils.isEmpty(entities)) {
            return Maps.newHashMap();
        }
        List<String> ids = entities.stream().map(o -> o.getId()).collect(Collectors.toList());
        List<SupplyRelationshipDetailEntity> detailEntities = this.detailRepository.findBySupplyRelationshipIds(ids);
        ArrayList supplyRelationshipVos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList(entities, SupplyRelationshipEntity.class, SupplyRelationshipVo.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList detailVos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList(detailEntities, SupplyRelationshipDetailEntity.class, SupplyRelationshipDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<SupplyRelationshipDetailVo>> detailVoListMap = detailVos.stream().collect(Collectors.groupingBy(SupplyRelationshipDetailVo::getSupplyRelationshipId));
        supplyRelationshipVos.forEach(o -> o.setDetailVos((List)detailVoListMap.get(o.getId())));
        Map<String, List<SupplyRelationshipVo>> listMap = supplyRelationshipVos.stream().collect(Collectors.groupingBy(SupplyRelationshipVo::getBuyerId));
        return listMap;
    }

    private void createValidate(List<SupplyRelationshipDto> dtos) {
        Validate.notEmpty(dtos, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dtos.forEach(dto -> {
            Validate.notBlank((CharSequence)dto.getBuyerId(), (String)"\u91c7\u8d2d\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getSupplierId(), (String)"\u4f9b\u8d27\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((Collection)dto.getDetailDtos(), (String)"\u91c7\u4f9b\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            dto.getDetailDtos().forEach(o -> {
                Validate.notBlank((CharSequence)o.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)o.getProductSpe(), (String)"\u4ea7\u54c1\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            });
        });
    }
}

