/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.notifier;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.customer.local.entity.CustomerEntity;
import com.biz.crm.mdm.business.customer.local.model.MultipleConditionModel;
import com.biz.crm.mdm.business.customer.local.service.CustomerService;
import com.biz.crm.mdm.business.customer.org.sdk.event.CustomerOrgEventListener;
import com.biz.crm.mdm.business.customer.org.sdk.vo.CustomerOrgVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CusCustomerOrgEventListener
implements CustomerOrgEventListener {
    @Autowired(required=false)
    private CustomerService customerService;
    @Autowired(required=false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    public void onBatchCreate(List<CustomerOrgVo> customerOrgVos) {
        if (CollectionUtils.isNotEmpty(customerOrgVos)) {
            CustomerOrgVo customerOrgVo = customerOrgVos.get(0);
            String onlyKey = customerOrgVo.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(null);
            crmBusinessLogDto.setNewObject((Object)customerOrgVo);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        }
    }

    public void onBatchUpdate(List<CustomerOrgVo> customerOrgVos) {
        if (CollectionUtils.isNotEmpty(customerOrgVos) && customerOrgVos.size() > 1) {
            CustomerOrgVo newCustomerOrgVo = customerOrgVos.get(0);
            CustomerOrgVo oldCustomerOrgVo = customerOrgVos.get(1);
            String onlyKey = newCustomerOrgVo.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setNewObject((Object)newCustomerOrgVo);
            crmBusinessLogDto.setOldObject((Object)oldCustomerOrgVo);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        }
    }

    public void onBatchDisable(List<CustomerOrgVo> customerOrgVos) {
        if (CollectionUtils.isEmpty(customerOrgVos)) {
            return;
        }
        customerOrgVos.stream().forEach(customerOrgVo -> {
            CustomerOrgVo newCustomerOrgVo = new CustomerOrgVo();
            CustomerOrgVo oldCustomerOrgVo = new CustomerOrgVo();
            newCustomerOrgVo.setEnableStatus(customerOrgVo.getEnableStatus());
            newCustomerOrgVo.setId(customerOrgVo.getId());
            oldCustomerOrgVo.setId(customerOrgVo.getId());
            oldCustomerOrgVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            String onlyKey = customerOrgVo.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject((Object)oldCustomerOrgVo);
            crmBusinessLogDto.setNewObject((Object)newCustomerOrgVo);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    public void onBatchEnable(List<CustomerOrgVo> customerOrgVos) {
        if (CollectionUtils.isEmpty(customerOrgVos)) {
            return;
        }
        customerOrgVos.stream().forEach(customerOrgVo -> {
            CustomerOrgVo newCustomerOrgVo = new CustomerOrgVo();
            CustomerOrgVo oldCustomerOrgVo = new CustomerOrgVo();
            newCustomerOrgVo.setEnableStatus(customerOrgVo.getEnableStatus());
            newCustomerOrgVo.setId(customerOrgVo.getId());
            oldCustomerOrgVo.setId(customerOrgVo.getId());
            oldCustomerOrgVo.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            String onlyKey = customerOrgVo.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject((Object)oldCustomerOrgVo);
            crmBusinessLogDto.setNewObject((Object)newCustomerOrgVo);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    public void onBatchDelete(List<CustomerOrgVo> eventDtos) {
        if (CollectionUtils.isEmpty(eventDtos)) {
            return;
        }
        List<String> customerOrgCodes = eventDtos.stream().map(CustomerOrgVo::getCustomerOrgCode).collect(Collectors.toList());
        MultipleConditionModel model = new MultipleConditionModel();
        model.setCustomerOrgCodes(customerOrgCodes);
        List<CustomerEntity> list = this.customerService.findByMultipleConditionModel(model);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(list), (String)"\u5b58\u5728\u4e0e\u5ba2\u6237\u7684\u7ed1\u5b9a\u5173\u7cfb\u4e0d\u80fd\u5220\u9664", (Object[])new Object[0]);
        eventDtos.stream().forEach(customerOrgVo -> {
            String onlyKey = customerOrgVo.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(customerOrgVo);
            crmBusinessLogDto.setNewObject(null);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }
}

