package com.biz.crm.mdm.business.customer.material.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 客户物料实体类
 *
 * @author huang.long
 * @date 2020-09-02 22:09:56
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerMaterial", description = "客户物料实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`mdm_customer_material`", comment = "客户物料实体类")
@TableName("mdm_customer_material")
@Table(name = "`mdm_customer_material`")
public class CustomerMaterial extends TenantFlagOpEntity {
  private static final long serialVersionUID = 2152163426308097175L;

  /**
   * 客户组织编码
   */
  @ApiModelProperty("客户组织编码")
  @Column(name = "customer_org_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户组织编码 '")
  private String customerOrgCode;

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  @Column(name = "material_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 物料编码 '")
  private String materialCode;

  /**
   * 条形码
   */
  @Column(name = "bar_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 条形码 '")
  private String barCode;

}
